/* Copyright KTH Royal Institute of Technology, Martin Ohlsson, Per Zetterberg
* This software is provided  as is. It is free to use for non-commercial purposes.
* For commercial purposes please contact Peter Hndel (peter.handel@ee.kth.se)
* for a license. For non-commercial use, we appreciate citations of our work,
* please contact, Per Zetterberg (per.zetterberg@ee.kth.se), 
* for how information on how to cite. */ 

package se.kth.android.StudentCode;

//import java.util.ArrayList;
//import java.util.Arrays;
//import java.util.Date;
import java.util.List;

//import org.apache.commons.net.ntp.TimeInfo;
//import org.apache.commons.net.ntp.TimeStamp;

//import se.kth.android.FrameWork.FrameWork;
import se.kth.android.FrameWork.StudentCodeBase;

//import android.graphics.Bitmap;
import android.graphics.Canvas;
//import android.graphics.Color;
//import android.graphics.Paint;
//import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Paint.Style;
import android.net.wifi.ScanResult;


public class StudentCode extends StudentCodeBase {
	


	// This is called before any other functions are initialized so that parameters for these can be set
	public void init()
	{
		// Name your project so that messaging will work within your project
		projectName = "DemoProject";
	
		// Add sensors your project will use
		useSensors = GYROSCOPE;//SOUND_IN|SOUND_OUT;//WIFI_SCAN | ACCELEROMETER | MAGNETIC_FIELD | PROXIMITY | LIGHT;//TIME_SYNC|SOUND_IN;//TIME_SYNC | ACCELEROMETER | MAGNETIC_FIELD | PROXIMITY | LIGHT | SOUND_IN;
										  // CAMERA
		// Set sample rate for sound in/out, 8000 for emulator, 8000, 11025 or 22050 for target device
		sampleRate = 22050;
		
		
		// Enable or disable logging of sensor data to memory card
		loggingOn = false;
		
		// If message communication is used between phones in the project, enable it here and set server address, type and group names
		useMessaging = false; 
		messageServer = "130.229.156.86";
		messageServerType = LINUX_MESSAGE_SERVER; // WEB_MESSAGE_SERVER
		
		//String temp[] =  {"MICROPHONE","SPEAKER"};
		//messageGroups = temp;
		messageGroups=null;
		  
		// If using time synchronization set the NTP time server address 
		ntpServer = "192.168.1.5";
		//ntpServer = "192.168.5.11";
				
		// Set the approximate interval in milliseconds for your need for calls to your process function
		processInterval = 1000;
		
		// If you access and modify data structures from several sensor functions and/or process you may need to make the calls
		// be performed in series instead of simultaneous to prevent exception when one function changes data at the same time as another 
		// reads it. If this is the case set useConcurrentLocks to true
		useConcurrentLocks = false;
		
		
		// If you want a text on screen before start is pressed put it here
		introText = "This is the empty version of FrameWork";
		
		
	}

	// This is called when the user presses start in the menu, reinitialize any data if needed
	public void start()
	{
	}

	// This is called when the user presses stop in the menu, do any post processing here
	public void stop()
	{
	}
	
	// Place your local field variables here
    int oscsize = 0;
	boolean getNextBuf = false;
	String triggerTime;
	String gpsData;
	String gyroData;
	String magneticData;
	String proximityData;
	String lightData;
	String screenData;
	String messageData;
	short[] sound_buffer = new short[8192];
	
	
	// Fill in the process function that will be called according to interval above
	public void process()
	{
		set_output_text(""+gyroData+"\n"+gpsData + "\n"+triggerTime+"\n"+ magneticData+"\n"+proximityData+"\n"+lightData+"\n"+screenData+"\n"+messageData);		//set_output_text(debug_output+"\n");
	}
	
	
	// Fill in the functions receiving sensor data to do processing 
	public void gps(long time, double latitude, double longitude, double height, double precision)
	{
		gpsData = "G: "+format4_2.format(latitude)+":"+format4_2.format(longitude)+":"+format4_2.format(height)+":"+format4_2.format(precision);
	}
	
	public void magnetic_field(long time, double x, double y, double z)
	{
		magneticData = "M: "+format4_2.format(x)+":"+format4_2.format(y)+":"+format4_2.format(z);
	}

	public void accelerometer(long time, double x, double y, double z)
	{
		triggerTime = "A: "+format4_2.format(x)+":"+format4_2.format(y)+":"+format4_2.format(z);
	}
	
	public void gyroscope(long time, double x, double y, double z)
	{
		gyroData = "G: "+format4_2.format(x)+":"+format4_2.format(y)+":"+format4_2.format(z);
	}
	public void proximity(long time, double p)
	{
		proximityData = "P: "+format4_2.format(p);
	}
	
	public void light(long time, double l)
	{
		lightData = "L: "+format4_2.format(l);
	}
	
	public void sound_in(long time, short[] samples, int length)
	{			
	}
	
	
	public void screen_touched(float x, float y) 
	{
	} 
		 
	// Implement your phone to phone receive messaging here
	public void message_in(StudentMessage message)
	{
	}		
	// Implement any plotting you need here 
	public void plot_data(Canvas plotCanvas, int width, int height) 
	{
		if((latestImage != null) && ((useSensors & CAMERA) == CAMERA)) // If camera is enabled, display
		{
			plot_camera_image(plotCanvas,latestImage,imageWidth,imageHeight,width,height);
		}
		
		
	}
	
	String wifi_ap = "";
	// Implement wifi ap analysis here
	public void wifi_ap(long time, List<ScanResult> wifi_list)
	{
		wifi_ap = "";
		for(ScanResult sr: wifi_list)
			wifi_ap += sr.SSID + " " + sr.level + "\n";  
	}

	// Implement reception of streaming sound here
	public void streaming_buffer_in(short[] buffer, int length, int senderId)
	{
		sound_out(buffer,length);
	}

	byte[] latestImage = null;
	int imageHeight = 0;
	int imageWidth = 0;
	public void camera_image(byte[] image, int width, int height)
	{
		/* Save latest image*/
		latestImage = image;
		imageWidth = width;
		imageHeight = height;
	}
	
	//This function is called before the framework executes normally  meaning that no sensors or
    // initialing is done.
    // If you return true the execution stops after this function.
    // Use this to test algorithms with static data.
    public boolean test_harness()
    {
    	boolean do_test=false; // Set to true when running test_harness_example
    	
     // The below code is used together with test_harness_example.m	
    if (do_test) {	
    	int no_of_real;
    	double [] in_values;
    	double [] out_values;

  
    	 
    	SimpleOutputFile out = new SimpleOutputFile();
    	SimpleInputFile in = new SimpleInputFile();
    	
    	in.open("indata.txt");    	    	
    	out.open("outdata.txt");
    	
    	// Read data from input file 
    	no_of_real=in.readInt();
    	in_values=new double[no_of_real];
    	// Read file from sdcard
    	for(int i=0; i<in_values.length; i++){
    		in_values[i]=in.readDouble(); 
    	};

    	
        // Call the function to be tested 
    	out_values=square(in_values);
    	
    	// Write file on sdcard 
    	for(int i=0; i<in_values.length; i++){
    		out.writeDouble(out_values[i]);
    	};
    	    	  
    	 
    	out.close();  
    	in.close();
    	
    	return true;
    } else
    return false;
   }

 /* Used in test_harness_example.m */
  private double [] square(double [] in_values) {
	double [] out_values;
	out_values = new double[in_values.length];
   	for(int i=0; i<in_values.length; i++){
		out_values[i]=in_values[i]*in_values[i];
	} 
   	return out_values;
   }

  
   
}



