/*
 * Decompiled with CFR 0.152.
 */
package becker.xtras.jotto;

import becker.util.Test;
import becker.xtras.jotto.IWordList;
import becker.xtras.jotto.IWordPredicate;
import becker.xtras.jotto.Word;
import becker.xtras.jotto.p;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Scanner;

public final class SampleWordList
implements IWordList {
    private Word[] a = new Word[10];
    private int b = 0;

    public SampleWordList(Scanner scanner) {
        while (scanner.hasNextLine()) {
            this.add(new Word(scanner));
        }
    }

    public SampleWordList() {
        Closeable closeable = IWordList.class.getResourceAsStream("words.txt");
        closeable = new Scanner(new InputStreamReader((InputStream)closeable));
        while (((Scanner)closeable).hasNextLine()) {
            this.add(new Word((Scanner)closeable));
        }
    }

    public final void add(Word word) {
        if (this.b >= this.a.length) {
            Word[] wordArray = new Word[this.a.length << 1];
            for (int i2 = 0; i2 < this.b; ++i2) {
                wordArray[i2] = this.a[i2];
            }
            this.a = wordArray;
        }
        this.a[this.b] = word;
        ++this.b;
    }

    public final boolean contains(String string) {
        for (int i2 = 0; i2 < this.b; ++i2) {
            if (!this.a[i2].getWord().equals(string)) continue;
            return true;
        }
        return false;
    }

    public final int numWords() {
        return this.b;
    }

    private Word a(int n2) {
        if (n2 >= this.b) {
            throw new IllegalArgumentException("words in list = " + this.b + "; requested " + n2);
        }
        return this.a[n2];
    }

    public final Word randomWord() {
        int n2 = (int)(Math.random() * (double)this.b);
        return this.a[n2];
    }

    public final Word randomWord(int n2) {
        int n3;
        int n4;
        for (n4 = n3 = (int)(Math.random() * (double)this.b); n4 < this.b; ++n4) {
            if (this.a[n4].getDifficulty() != n2) continue;
            return this.a[n4];
        }
        for (n4 = 0; n4 < n3; ++n4) {
            if (this.a[n4].getDifficulty() != n2) continue;
            return this.a[n4];
        }
        return null;
    }

    public final Word getWord(IWordPredicate iWordPredicate) {
        int n2;
        int n3;
        for (n3 = n2 = (int)(Math.random() * (double)this.b); n3 < this.b; ++n3) {
            if (!iWordPredicate.isOK(this.a[n3])) continue;
            return this.a[n3];
        }
        for (n3 = 0; n3 < n2; ++n3) {
            if (!iWordPredicate.isOK(this.a[n3])) continue;
            return this.a[n3];
        }
        return null;
    }

    public final Word[] getWords(IWordPredicate iWordPredicate) {
        int n2 = 0;
        for (int i2 = 0; i2 < this.b; ++i2) {
            if (!iWordPredicate.isOK(this.a[i2])) continue;
            ++n2;
        }
        Word[] wordArray = new Word[n2];
        n2 = 0;
        for (int i3 = 0; i3 < this.b; ++i3) {
            if (!iWordPredicate.isOK(this.a[i3])) continue;
            wordArray[n2] = this.a[i3];
            ++n2;
        }
        return wordArray;
    }

    public final Word[] getWords(int n2, IWordPredicate iWordPredicate) {
        int n3;
        int n4 = 0;
        int n5 = (int)(Math.random() * (double)this.b);
        for (n3 = 0; n3 < this.b && n4 < n2; ++n3) {
            if (!iWordPredicate.isOK(this.a[(n5 + n3) % this.b])) continue;
            ++n4;
        }
        n3 = Math.min(n4, n2);
        Word[] wordArray = new Word[n3];
        n4 = 0;
        for (int i2 = 0; i2 < this.b && n4 < n3; ++i2) {
            int n6 = (n5 + i2) % this.b;
            if (!iWordPredicate.isOK(this.a[n6])) continue;
            wordArray[n4] = this.a[n6];
            ++n4;
        }
        return wordArray;
    }

    public static void main(String[] object) {
        System.out.println("\n    Testing SampleWordList");
        object = new SampleWordList(new Scanner(new StringReader("ABACK 0\nQUACK 2\nNYMPH 2\n")));
        Test.ckEquals("num words-0", 3, ((SampleWordList)object).numWords());
        Test.ckEquals("1st word", "ABACK", super.a(0).getWord());
        Test.ckEquals("2nd word", "QUACK", super.a(1).getWord());
        Test.ckEquals("3rd word (a)", "NYMPH", super.a(2).getWord());
        Test.ckEquals("3rd word (b)", "NYMPH", super.a(2).getWord());
        Test.ckEquals("1st difficulty", 0, super.a(0).getDifficulty());
        String string = ((SampleWordList)object).randomWord(2).getWord();
        Test.ckEquals("random word", true, string.equals("QUACK") || string.equals("NYMPH"));
        Test.ckEquals("no random word", null, ((SampleWordList)object).randomWord(1));
        Test.ckEquals("contains", true, ((SampleWordList)object).contains("ABACK"));
        Test.ckEquals("not contains", false, ((SampleWordList)object).contains("LICKS"));
        object = ((SampleWordList)object).getWords(1, new p());
        Test.ckEquals("getWords", 1, ((Object)object).length);
        Test.ckEquals("getWords 1", true, ((Word)object[0]).getWord().equals("ABACK") || ((Word)object[0]).getWord().equals("QUACK"));
        object = new SampleWordList();
        Test.ckEquals("num words", 4245, ((SampleWordList)object).numWords());
        Test.ckEquals("first word", "CARVE", super.a(0).getWord());
    }
}

