/*
 * Decompiled with CFR 0.152.
 */
package becker.xtras.jotto;

import becker.util.Test;
import becker.xtras.jotto.IHintData;
import becker.xtras.jotto.IWordPredicate;
import becker.xtras.jotto.Word;

public abstract class Hint
implements IWordPredicate {
    public static final int LETTER = 0;
    public static final int LETTERS = 1;
    public static final int GUESSES = 2;
    public static final int NONE = 3;
    public static final int DIFFICULTY = 4;
    private final String a;
    private final int b;

    public Hint(String string, int n2) {
        if (n2 < 0 || n2 > 4) {
            throw new IllegalArgumentException("argType must be one of {LETTER, LETTERS, GUESSES, DIFFICULTY, NONE}.");
        }
        this.a = string;
        this.b = n2;
    }

    public final String getDescription() {
        return this.a;
    }

    public final int getArgumentType() {
        return this.b;
    }

    public abstract boolean isOK(Word var1);

    public abstract Word[] getHintWords(int var1, IHintData var2);

    public static void main(String[] object) {
        System.out.println("\n    Testing Hint");
        Test.ckIsBetween("argType range", 0, 4, 4);
        Test.ckIsBetween("argType range", 0, 2, 4);
        Test.ckIsBetween("argType range", 0, 0, 4);
        Test.ckIsBetween("argType range", 0, 1, 4);
        Test.ckIsBetween("argType range", 0, 3, 4);
        object = new a("test", 0);
        Test.ckEquals("arg type", 0, ((Hint)object).getArgumentType());
        Test.ckEquals("descr", "test", ((Hint)object).getDescription());
        try {
            new a("test2", 5);
            Test.fail("Illegal argument exception not thrown -- 1");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Test.pass("illegal argument -- 1");
        }
        try {
            new a("test2", -1);
            Test.fail("Illegal argument exception not thrown -- 2");
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Test.pass("illegal argument -- 2");
            return;
        }
    }

    private static final class a
    extends Hint {
        a(String string, int n2) {
            super(string, n2);
        }

        public final boolean isOK(Word word) {
            return true;
        }

        public final Word[] getHintWords(int n2, IHintData iHintData) {
            return null;
        }
    }
}

