/*
 * Decompiled with CFR 0.152.
 */
package becker.robots.icons;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public abstract class Icon {
    private Image a;
    private double b = 1.0;
    private double c = 1.5707963267948966;
    private String d = "";
    private boolean e = true;
    private Color f = Color.BLACK;
    private double g = 0.0;
    public static final Color transparent = new Color(0, 0, 0, 0);

    public Icon() {
        this(1.0, Color.BLACK);
    }

    public Icon(double d2) {
        this(d2, Color.BLACK);
    }

    public Icon(Color color) {
        this(1.0, color);
    }

    public Icon(double d2, Color color) {
        this.b = d2;
        this.f = color;
    }

    public Color getColor() {
        return this.f;
    }

    public void setColor(Color color) {
        this.f = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0 * (1.0 - this.g)));
        this.markChanged();
    }

    public double getTransparency() {
        return this.g;
    }

    public void setTransparency(double d2) {
        if (d2 < 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("trans = " + d2 + "; must be 0.0 <= trans <= 1.0.");
        }
        this.g = d2;
        this.setColor(this.f);
    }

    public double getSize() {
        return this.b;
    }

    public void setSize(double d2) {
        if (!(0.0 < d2) || !(d2 <= 1.0)) {
            throw new IllegalArgumentException("0.0 < relativeSize <= 1.0");
        }
        this.b = d2;
        this.markChanged();
    }

    protected double getRotation() {
        return this.c + 1.5707963267948966;
    }

    public String getLabel() {
        return this.d;
    }

    public void setLabel(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Label shouldn't be null.");
        }
        this.d = string;
        this.markChanged();
    }

    protected void markChanged() {
        this.e = true;
    }

    protected boolean hasChanged() {
        return this.e;
    }

    protected void renderImage(Graphics2D graphics2D, int n2, int n3) {
        graphics2D.scale(0.01, 0.01);
        graphics2D.setStroke(new BasicStroke(0.01f));
        this.paintIcon(graphics2D);
    }

    protected void paintIcon(Graphics graphics) {
    }

    public Image getImage(int n2, int n3, double d2) {
        boolean bl = this.hasChanged();
        if (bl || this.a == null || this.a.getWidth(null) != n2 || this.a.getHeight(null) != n3 || this.c != d2) {
            this.a = new BufferedImage(n2, n3, 2);
            bl = true;
        }
        if (bl) {
            this.c = d2;
            Graphics2D graphics2D = (Graphics2D)this.a.getGraphics();
            this.applyTransforms(graphics2D, n2, n3, this.getRotation(), this.b);
            graphics2D.setColor(this.f);
            this.renderImage(graphics2D, n2, n3);
            if (this.d.length() > 0) {
                this.a(graphics2D, n2, n3);
            }
            graphics2D.dispose();
        }
        return this.a;
    }

    private void a(Graphics2D graphics2D, int n2, int n3) {
        int n4;
        FontMetrics fontMetrics;
        int n5 = 16;
        int n6 = 1;
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.setTransform(new AffineTransform());
        graphics2D.setClip(null);
        while (true) {
            graphics2D.setFont(new Font("Serif", n6, n5));
            fontMetrics = graphics2D.getFontMetrics();
            n4 = fontMetrics.stringWidth(this.d);
            if (n4 < n2 - 4) break;
            if (n5 >= 12) {
                n5 -= 2;
                continue;
            }
            if (n6 == 1) {
                n6 = 0;
                continue;
            }
            --n5;
        }
        n4 = fontMetrics.getAscent();
        n5 = fontMetrics.stringWidth(this.d);
        graphics2D.translate(Math.max((double)n2 / 2.0 - (double)n5 / 2.0, 0.0), Math.min((double)n3 / 2.0 + (double)n4 / 2.0, (double)n3));
        graphics2D.setColor(Color.black);
        graphics2D.drawString(this.d, 0, 0);
        graphics2D.setTransform(affineTransform);
    }

    protected void applyTransforms(Graphics2D graphics2D, int n2, int n3, double d2, double d3) {
        graphics2D.translate((double)n2 / 2.0, (double)n3 / 2.0);
        graphics2D.scale((double)n2 * d3, (double)n3 * d3);
        graphics2D.rotate(d2);
        graphics2D.translate(-0.5, -0.5);
        graphics2D.setStroke(new BasicStroke(1.0f / (float)n2));
    }
}

