/*
 * Decompiled with CFR 0.152.
 */
package becker.robots.icons;

import becker.robots.icons.Icon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

public class CompositeIcon
extends Icon {
    private Icon[] a;
    private double b;
    private double c;

    public CompositeIcon(Icon icon, Icon icon2) {
        this.a = new Icon[2];
        this.a[0] = icon;
        this.a[1] = icon2;
    }

    public CompositeIcon(Icon[] iconArray) {
        if (iconArray.length < 1) {
            throw new IllegalArgumentException("Precondition: icons.length >= 1");
        }
        this.a = iconArray;
    }

    protected void renderImage(Graphics2D graphics2D, int n2, int n3) {
        AffineTransform affineTransform = graphics2D.getTransform();
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            Icon icon = this.a[i2];
            graphics2D.translate((double)n2 / 2.0, (double)n3 / 2.0);
            graphics2D.scale((double)n2 * this.b * icon.getSize(), (double)n3 * this.b * icon.getSize());
            graphics2D.rotate(this.c);
            graphics2D.translate(-0.5, -0.5);
            graphics2D.setStroke(new BasicStroke(1.0f / (float)n2));
            graphics2D.setColor(icon.getColor());
            icon.renderImage(graphics2D, n2, n3);
            graphics2D.setTransform(affineTransform);
        }
    }

    protected void applyTransforms(Graphics2D graphics2D, int n2, int n3, double d2, double d3) {
        this.b = d3;
        this.c = d2;
    }

    protected void markChanged() {
        super.markChanged();
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            this.a[i2].markChanged();
        }
    }

    public boolean hasChanged() {
        int n2;
        if (super.hasChanged()) {
            return true;
        }
        for (n2 = 0; n2 < this.a.length && !this.a[n2].hasChanged(); ++n2) {
        }
        return n2 < this.a.length;
    }

    public Icon componentIcon(int n2) {
        if (n2 >= 0 && n2 < this.numComponents()) {
            return this.a[n2];
        }
        throw new IllegalArgumentException("Precondition: 0 <= index < this.numComponents()");
    }

    public int numComponents() {
        return this.a.length;
    }

    public Color getColor() {
        return null;
    }

    public void setColor(Color color) {
    }
}

