import java.util.Comparator;

public class CompByGoals implements Comparator<PlayerC> {
    public int compare(PlayerC player1, PlayerC player2) {
        // We are deciding based on the number of goals,
        // which is an {\tt int}, not an object!  There is no
        // builtin comparison function.  We can create an 
        // Integer object and use the compareTo function for 
        // Integer, although really it would be simpler to write
        // the code by ourselves!

        return (new Integer(player1.goals)).compareTo(player2.goals);
    }
}
