import static dit948.SimpleIO.*;

import java.util.Arrays;

/* Notice that we can extend a class and at the same 
   time implement an interface (or as many as we want).
   
   We will compare instances of PrintablePlayerO with
   instances of PlayerC.  After all, a PrintablePlayerO
   "is a" PlayerC, and so is a PrintablePlayer.

   Therefore, the parameter passed to the interface
   (in angular brackets) is PlayerC.
*/
public class PrintablePlayerO extends PrintablePlayer implements Comparable<PlayerC> {

    public PrintablePlayerO(String name, int goals) {
        super(name, goals);
    }

    // compareTo is the only method in interface Comparable
    // The signature is fully specified once we have decided
    // on the type of objects in the "implements" declaration
    // above.
    public int compareTo(PlayerC other) {
        // We're ordering players by name.
        return name.compareTo(other.name);
    }

    public static void main(String[] args) {
        // Create some printable players with order.
        PrintablePlayerO ibrahimovic = new PrintablePlayerO("Ibrahimovic", 5);
        PrintablePlayerO berg = new PrintablePlayerO("Berg", 2);
        PrintablePlayerO toivonen = new PrintablePlayerO("Toivonen", 3);
        PrintablePlayerO källström = new PrintablePlayerO("Källström", 1); 

        // Create an array to store the players.
        PrintablePlayerO[] players = new PrintablePlayerO[4];

        players[0] = ibrahimovic; players[1] = berg; players[2] = toivonen; players[3] = källström;
        
        // Print the array before sorting.
        println(Arrays.toString(players));

        // Sort the array.
        Arrays.sort(players);

        // Print the array after sorting.
        println(Arrays.toString(players));

        // The result is not very good:
        // [Berg 2, Ibrahimovic 5, Källström 1, Toivonen 3]

    }
}
