import static dit948.SimpleIO.*;

// Introduce a new type, PrintExample
public class PrivateExample {
    // Introduce a private field, msg.
    private String msg;

    // Constructor.
    // Initializes msg
    // OK, msg is in scope throughout the class
    public PrivateExample() {
        msg = "Can't touch this!";
    }

    // Introduce a method, changeMsg, which
    // takes an instance of PrivateExample as argument.
    public void changeMsg(PrivateExample loser) {
        // Change loser.msg
        // OK, loser.msg is in scope in class PrivateExample
        loser.msg = "I'm a loser, baby.";
    }

    public String toString() {
        return msg;
    }

    public static void main(String[] args) {
        // Introduce two variables of type PrivateExample
        PrivateExample x1, x2;

        // Initialize them.
        x1 = new PrivateExample();
        x2 = new PrivateExample();

        // Print x1
        println(x1);
        // x1 prints the value of x1.msg
        // Result:
        // Can't touch this!

        // Pass x1 to x2
        x2.changeMsg(x1);

        // Print x1 again
        println(x1);
        // x1 prints the value of x1.msg
        // Result:
        // x2 has changed the value of the private variable of x1
        // I'm a loser, baby.
    }
}
