/**
 * Quick recap of lecture 2
 * @author musard
 *
 */

import static dit948.SimpleIO.*;
import static dit948.Random.*;


public class Recap {

	/**
	 * This is the main method
	 * Program execution always starts from here
	 * @param args
	 */
	public static void main(String[] args) {

		/*
		 * Variable declaration and initialization
		 * A variable must be declared and initialized 
		 * before being used in an expression.
		 * Constants can never be changed by the program.
		 * Always use meaningful names for your variables
		 * 
		 */
		
		int intVar = 15;
		double  doubleVar = 12.5;
		char charVar = '9';
		String stringVar = "Hej";
		boolean booleanVar = true;
		final double PI = 3.14;
		
		println("The value of intVar is " + intVar);
		println("The value of doubleVar is " + doubleVar);
		println("The value of charVar is " + charVar);
		println("The value of stringVar is " + stringVar);
		println("The value of booleanVar is " + booleanVar);
		println("The value of constant PI is " + PI);
		
		/* 
		 * I/O using library dit948
		 */
		
		println("Enter an integer: ");
		int inputInt = readInt(); 
		print("Enter a real: ");
		double inputDouble = readDouble();
		print("Enter a string: ");
		String inputString = readString();
		print("Enter a line: ");
		String inputLine = readLine();
		print("Enter a boolean: ");
		boolean inputBoolean = readBoolean();
		print("Enter a char: ");
		char inputChar = readChar();
		
		println("Great job! You entered:\ninteger: " + inputInt +
				"\nreal: " + inputDouble + "\nstring: " + inputString +
				"\nline: " + inputLine + "\nboolean: " + inputBoolean +
				"\nchar: " + inputChar );

		println("Can you generate random values now?");
		
		int randomInt = randomInt();
		int randomIntUpTo100 = randomInt(101);
		boolean randomBoolean = randomBoolean();
		
		println("The random values are: ");
		println("Random integer: " + randomInt);
		println("Random integer (between 0 - 100): " + randomIntUpTo100);
		println("Random boolean: " + randomBoolean);
		println("Awesome! You know everything about I/O now.");
		
		/*
		 * Assignments and other operators
		 */
		
		// Increment IntVar by 1
		
		intVar++; // this is the same as intVar = intVar + 1
		
		intVar--; // well, you can guess it yourself
		
		// add 15 to intVar
		
		intVar+=15; // this is the same as intVar = intVar + 15
		
		intVar-=15;  // indeed, now intVar is back to its
					 // initial value
		
		// What about booleans?
		
		boolean trueBool = true;
		boolean falseBool = false;
		boolean resBool;
		
		println("If trueBool = " + trueBool + " and falseBool = " +
		falseBool + "then ");
		
		resBool = trueBool && falseBool;
		println("true AND false = " + resBool);
		
		resBool = trueBool || falseBool;
		println("true OR false = " + resBool);
		
		//Conditional expression
		double conditionalDouble = intVar > randomInt ? 25.5 : 13.9;
		
		println(conditionalDouble);
		
		/*
		 * Operations on Strings
		 */
		
		String s = "Hello";
		String s1 = "He";
		String s2 = "12";
		String s3 = "12.2";
		char c = '5';

		s.length();      //returns the integer 5
		s.equals(s1);    // returns the boolean false
		s.charAt(1);     // returns the char 'e'
		s.substring(0, 2); // returns the String "He"
		s.substring(3);  // returns the String "lo"
		s.indexOf(s1);   // returns the integer 0

		Integer.parseInt(s2);           // returns the integer 12
		Double.parseDouble(s3);         // returns the double 12.2
		Character.getNumericValue(c);   // returns integer 5
		String.valueOf(c);              // returns the String "5"
		
	}

}
