import becker.robots.*;

import java.util.Scanner;

public class SysInRobot extends SmartRobot {

    Scanner scan;

    public SysInRobot(City c, int st, int av, Direction d) {
        super(c, st, av, d);
        scan = new Scanner(System.in);
    }

    public void readAndExecute() {
        int cmd = 4;

        try {
            cmd = scan.nextInt();
        } catch(Exception e) {
            System.err.println(e);
        }

        switch(cmd) {
        case 0:
            move();
            break;
        case 1:
            turnLeft();
            break;
        case 2:
            turnAround();
            break;
        case 3:
            turnRight();
            break;
        }
    }

    public static void main(String[] args) {
        FirstWorld world = new FirstWorld(11);
        world.putWalls();

        world.setFrameTitle("SysInRobot");

        SysInRobot sir = new SysInRobot(world, 5, 5, Direction.NORTH);

        for(int i = 0; i < 200; i++)
            sir.readAndExecute();
    }

}
