import becker.robots.*;

import java.net.*;
import java.io.*;

public class SocketInput {
    public static void main(String[] args) {
        FirstWorld world = new FirstWorld(11);
        world.putWalls();

        world.setFrameTitle("BufSysInRobot");

        BufInRobot bir = new BufInRobot(world, 5, 5, Direction.NORTH);

        String allowedHostAddress = "127.0.0.1";

        int port = 30000;
        
        try {
            ServerSocket server = new ServerSocket(port);
            System.out.println("Opened server");
            boolean done = false;
            do {
                System.out.println("Waiting for connection");
                Socket socket = server.accept();
                System.out.println("Checking connection");
                InetAddress incoming = socket.getInetAddress();
                String incomingHostAddress = incoming.getHostAddress();
                done = incomingHostAddress.equals(allowedHostAddress);
                if (done) {
                    System.out.println("Connected");
                    bir.setIn(socket.getInputStream());
                    for(int i = 0; i < 200; i++)
                        bir.readAndExecute();
                    
                    socket.close();
                } else {
                    System.out.println("Rejected connection from "+
                                       incomingHostAddress);
                    socket.close();
                }
            } while (!done);

            
        } catch (Exception e) {
            System.out.println(e);
        }
        
 
    }
}
