import static dit948.Random.*;

import becker.robots.*;

import java.io.*;

public class OutRobot extends RandomRobot {

    PrintStream out;

    public OutRobot(City c, int st, int av, Direction d) {
        super(c, st, av, d);
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public void randomMove() {
        int nrTurns = randomInt(4); // how many "turnLeft"s?
        switch(nrTurns) {
        case 0: 
            // no turns, do nothing 
            break;
        case 1:
            turnLeft();
            out.println(1);
            break;
        case 2:
            turnAround();
            out.println(2);
            break;
        case 3:
            turnRight();
            out.println(3);
            break;
        }
        out.println(0);
        move();
    }

    public static void main(String[] args) {
        FirstWorld world = new FirstWorld(11);
        world.putWalls();

        world.setFrameTitle("OutRobot");

        OutRobot rob = new OutRobot(world, 5, 5, Direction.NORTH);

        // Write output to a file
        File cmds = new File("cmds");
        try {
            
            PrintStream out = new PrintStream(cmds);
            rob.setOut(out);
            rob.go(100);
            out.close();
        } catch (Exception e)  {
            System.err.println(e);
        }
    }
}
