import becker.robots.*;

import java.util.Scanner;
import java.io.*;

public class BufSysInRobot extends SmartRobot {

    BufferedReader buf;

    public BufSysInRobot(City c, int st, int av, Direction d) {
        super(c, st, av, d);
        buf = new BufferedReader (new InputStreamReader(System.in));
    }

    public void readAndExecute() {
        int cmd = 4;

        String line = null;

        try {

            while (line == null)
                line = buf.readLine();
            Scanner scan = new Scanner(line);
            cmd = scan.nextInt();
        } catch(Exception e) {
            System.err.println(e);
        }

        switch(cmd) {
        case 0:
            move();
            break;
        case 1:
            turnLeft();
            break;
        case 2:
            turnAround();
            break;
        case 3:
            turnRight();
            break;
        }
    }

    public static void main(String[] args) {
        FirstWorld world = new FirstWorld(11);
        world.putWalls();

        world.setFrameTitle("BufSysInRobot");

        BufSysInRobot sir = new BufSysInRobot(world, 5, 5, Direction.NORTH);

        for(int i = 0; i < 200; i++)
            sir.readAndExecute();
    }

}
