import becker.robots.*;

import java.util.Scanner;
import java.io.*;

public class BufInRobot extends SmartRobot {

    BufferedReader buf;

    public BufInRobot(City c, int st, int av, Direction d) {
        super(c, st, av, d);
    }

    public void setIn(InputStream in) {
        buf = new BufferedReader (new InputStreamReader(in));
    }

    public void readAndExecute() {
        int cmd = 4;

        String line = null;

        try {

            while (line == null)
                line = buf.readLine();
            Scanner scan = new Scanner(line);
            cmd = scan.nextInt();
        } catch(Exception e) {
            System.err.println(e);
        }

        switch(cmd) {
        case 0:
            move();
            break;
        case 1:
            turnLeft();
            break;
        case 2:
            turnAround();
            break;
        case 3:
            turnRight();
            break;
        }
    }

    public static void main(String[] args) {
        FirstWorld world = new FirstWorld(11);
        world.putWalls();

        world.setFrameTitle("BufSysInRobot");

        BufInRobot bir = new BufInRobot(world, 5, 5, Direction.NORTH);

        // Read input from a file
        File cmds = new File("cmds");
        try {
            
            FileInputStream in = new FileInputStream(cmds);
            bir.setIn(in);

            for(int i = 0; i < 200; i++)
                bir.readAndExecute();
        } catch (Exception e) {
            System.err.println(e);
        }
    }
}
