% Sauer Computer Problem 8.1.1 (a)
%
% Lös värmeledningsekvationen u_t = 2*u_xx
% med givna initial- och randvillkor.
%
% Joar Bagge 2016-12-05

clear

% Steglängder
dx = 0.1;
dt = 0.002; % stabil om dt < 0.0025

X = 0:dx:1;
T = 0:dt:1;

% Initial- och randvillkor som funktioner
u_init = @(x) 2*cosh(x);
u_left = @(t) 2*exp(2*t);
u_right = @(t) (exp(1)+exp(-1))*exp(2*t);

n = numel(X)-1; m = numel(T)-1;
U = zeros(n+1,m+1);
% Initialvillkoret
U(:,1) = u_init(X);
% Stega framåt i tiden
for j=1:m
    % Inre punkter
    i = 2:n; % vektor [2, 3, 4, ..., n]
    U(i,j+1) = U(i,j) + 2*dt/dx^2 * (U(i+1,j)-2*U(i,j)+U(i-1,j));
    % Randvillkor
    U(1,j+1) = u_left(T(j+1));
    U(end,j+1) = u_right(T(j+1));
end

mesh(T,X,U)
xlabel('Tid t')
ylabel('Position x')
zlabel('Temperatur T')
