% ENM 4.11
%
% Minsta kvadratmetoden för att anpassa en modell till datapunkter.
%
% Joar Bagge 2016-12-05

clear

%%
% Datapunkter vid T=0
v = [2 5 8 11 14]';
Thud = [0 -7.5 -12 -14.5 -16.5]';

% Anpassning av modellen
%
%   f(v,T) = 33 - (a + b*v + c*sqrt(v))*(33-T)
%
% till data leder till systemet A*x = h,
% där x = [a b c]'.
A = -33*[ones(size(v)), v, sqrt(v)]
h = Thud - 33

Asize = size(A) % systemet är överbestämt

%%
% Lös ut koefficienterna med minsta kvadratmetoden
x = A\h; % som att lösa normalekvationerna
a = x(1), b = x(2), c = x(3)

%%
% Rita upp data och kurvan, beräkna felkvadratsumman
% och rms-felet
f = @(v,T) 33 - (a + b*v + c*sqrt(v))*(33-T); % modellen

figure(1), clf
scatter(v, Thud) % data
hold on
vv = linspace(0, 15, 100);
ff = f(vv,0);
plot(vv, ff) % kurvan
xlabel('Vindstyrka v (m/s)')
ylabel('Hudtemperatur (°C)')

fel = Thud - f(v,0) % residualvektorn (skillnad mellan datapunkter och kurvan)
felkvsum = sum(fel.^2) % summan av kvadraterna
rmsfel = sqrt(felkvsum/numel(v)) % rms-felet

%%
% Räkna ut Thud vid T=-5 och v=7
f(7,-5)
