% Lösning till ENM 3.14 -- hitta den punkt på kurvan med störst y-värde
%
% Detta skript använder Newtons metod för ett ickelinjärt system.
%
% Joar Bagge 2016-11-24

clear

% Funktionen som vi ska hitta nollställe till
f = @(u,a) [u(1)^2 + u(2)^2 - 1 - a*sin(u(1)*u(2));
            2*u(1) - a*u(2)*cos(u(1)*u(2))];

% Funktionens derivata (Jacobimatrisen)
J = @(u,a) [2*u(1)-a*u(2)*cos(u(1)*u(2)), 2*u(2)-a*u(1)*cos(u(1)*u(2));
            2+a*u(2)^2*sin(u(1)*u(2)), -a*cos(u(1)*u(2))+a*u(1)*u(2)*sin(u(1)*u(2))];

% Startgissning? Provar högsta punkten på enhetscirkeln (a=0)
u = [0;1];

tol = 1e-12;
for a=[0.8, 1.6, 2.4, 3.2]
  % Newtons metod
  % Fortsätt så länge ändringen i u är större än toleransen.
  du = Inf;
  while norm(du) >= tol
    du = -J(u,a)\f(u,a);
    u = u + du;
  end
  u % skriv ut svaret
  % Obs: eftersom vi inte nollställer u någonstans i loopen
  % kommer det förra svaret bli ny startgissning för nästa
  % a-värde. Verkar vettigt om man tittar på kurvorna för olika a.
end
