% Lösning till uppgift ENM 7.3 -- Euler framåt för skalär ekvation
% Joar Bagge 2016-11-11

clear

% Givna värden på parametrar
g = 9.81;
vinf = 5; % hastighet efter lång tid
alpha = 1.1;

h = 0.05; % steglängd
v0 = 50; % initialvärde
t0 = 0; tend = 1; % tidsintervall

% Högerled till ekvationen v' = f(v)
f = @(v) g*(1-(v/vinf)^alpha);

N = (tend-t0) / h; % antal steg
t = t0:h:tend; % vektor med alla tidpunkter
v = zeros(1,length(t)); % lösningsvektor (fylls i loopen nedan)
v(1) = v0; % sätt initialvärdet!

% Euler framåt
for n=1:N
    v(n+1) = v(n) + h*f(v(n));
end
plot(t,v)
vend = v(end)
