/* File: UserQuadrature.hpp
 *
 * Class implementing a user-defined interpolatory integration
 * 
 * C Michael Hanke 2023
 * Version: 2023-02-14
 */

/* 
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.

*/

#ifndef USERQUADRATURE_HPP
#define USERQUADRATURE_HPP

#include "LSCMConfig.hpp"
#include "QuadratureRule.hpp"
#include <Eigen/Dense>
#include <iostream>
#include <cstdlib>

namespace LSCM {

/**
 * Implementation of a user defined quadrature
 * 
 * This class implements the interface of QuadratureRule for a 
 * user defined quadrature based on polynomial interpolation
 */
class UserQuadrature : public QuadratureRule {
private:
    void generate();
    
public:
    UserQuadrature() = delete;
    
    /**
     * Constructor
     * 
     * \param[in] tau vector of integration nodes. It must hold
     *            -1 <= tau(0) < ... < tau(end) <= 1.
     */
    UserQuadrature(Eigen::VectorXd tau) : QuadratureRule(tau) { }
    
    ~UserQuadrature() = default;

};

}

#endif
