/* File: Radau.hpp
 *
 * Class implementing the Radau-Legendre integration
 * 
 * C Michael Hanke 2023
 * Version: 2023-02-13
 */

/* 
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.

*/

#ifndef RADAU_HPP
#define RADAU_HPP

#include "QuadratureRule.hpp"
#include "LSCMConfig.hpp"

namespace LSCM {

/**
 * Implementation of Radau-Legendre quadrature
 * 
 * This class implements the interface of QuadratureRule for the 
 * Radau-Legendre quadrature
 */
class Radau : public QuadratureRule {
private:
    bool left_;
    void generate();
    
public:
    Radau() = delete;
    
    /**
     * Constructor
     * 
     * \param[in] n number of nodes
     * \param[in] left left or right aligned method
     */
    Radau(LSCMint n, bool left = true) : QuadratureRule(n), left_(left) {}
    
    ~Radau() = default;
};

}

#endif
