/* File: Lobatto.hpp
 *
 * Class implementing the Lobatto-Legendre integration
 * 
 * C Michael Hanke 2023
 * Version: 2023-02-13
 */

/* 
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.

*/

#ifndef LOBATTO_HPP
#define LOBATTO_HPP

#include "QuadratureRule.hpp"
#include "LSCMConfig.hpp"
#include <iostream>
#include <cstdlib>

namespace LSCM {

/**
 * Implementation of Lobatto-Legendre quadrature
 * 
 * This class implements the interface of QuadratureRule for the 
 * Lobatto-Legendre quadrature
 */
class Lobatto : public QuadratureRule {
private:
    void generate();
    void genlobatto();
    
public:
    Lobatto() = delete;
    
    /**
     * Constructor
     * 
     * \param[in] n number of nodes
     */
    Lobatto(LSCMint n) : QuadratureRule(n) {
        if (n < 2) {
            std::cerr << "Error Lobatto: n must be at least 2!" << std::endl;
            exit(1);
        }
    }
    
    ~Lobatto() = default;
};

}

#endif
