/* File: LegendreD.cpp
 *
 * This class implements the interface of class Basis using Legendre polynomials
 * for representing polynomials for the differential components.
 * 
 * C Michael Hanke 2019
 * Version: 2020-01-30
 */

/* 
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.

*/

#include "LegendreD.hpp"
#include <Eigen/Dense>
#include <iostream>
#include <cstdlib>
#include <vector>

using namespace std;
using namespace Eigen;

 VectorXd LSCM::LegendreD::legendreP(double tau) const {
    VectorXd res(dim+1);
    res(0) = 1.0;
    double x = 2*tau-1.0;
    res(1) = x;
    for (LSCMint i = 2; i <= dim; ++i) {
        double tmp = x*res(i-1);
        res(i) = (((double) (i-1))/i)*(tmp-res(i-2))+tmp;
    }
    return res;
}

VectorXd LSCM::LegendreD::evaldPd(double tau) const {
    VectorXd res(dim+1);
    res(0) = 0.0;
    res(1) = 2.0;
    double x = 2*tau-1.0;
    for (LSCMint i = 2; i <= dim; ++i) {
        double tmp = x*res(i-1);
        res(i) = (((double) i)/(i-1))*(tmp-res(i-2))+tmp;
    }
    return res;
}
