/* File: LSCMConfig.hpp
 *
 * This class defines some constants and types for the implementation of LSCM.
 * 
 * The basic aim of this class is to adapt the sparse matrix structures to those
 * used in SuiteSparse, in particular SPQR.
 *
 * Copyright (C) Michael Hanke 2020
 * Version: 2020-11-18
 */

/* 
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.

*/

#ifndef LSCMCONFIG_HPP
#define LSCMCONFIG_HPP

#ifdef USEMKL
#include <mkl.h>
#else
#include <lapacke.h>
#endif

#ifdef __cplusplus

#include <SuiteSparse_config.h>
#include <Eigen/SparseCore>

/**
 * This class defines some constants and types for the implementation of LSCM.
 * In particular, the types used in SPQR must be used directly.
 */
namespace LSCM {
    typedef Eigen::SparseMatrix<double,Eigen::ColMajor,SuiteSparse_long>
        LSCMSparseMatrix;
    
    typedef Eigen::Triplet<double,SuiteSparse_long> LSCMTriplet;
    
    typedef SuiteSparse_long LSCMindex;
#endif
    
    // This type is for compatibility with the BLAS/LAPACK library
    typedef lapack_int LSCMint;
#ifdef __cplusplus
}
#endif

#endif
