/* File: GaussLegendre.hpp
 *
 * Class implementing the Gauss-Legendre integration
 * 
 * C Michael Hanke 2023
 * Version: 2020-02-13
 */

/* 
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.

*/

#ifndef GAUSSLEGENDRE_HPP
#define GAUSSLEGENDRE_HPP

#include "LSCMConfig.hpp"
#include "QuadratureRule.hpp"

namespace LSCM {

/**
 * Implementation of Gauss-Legendre quadrature
 * 
 * This class implements the interface of QuadratureRule for the 
 * Gauss-Legendre quadrature
 */
class GaussLegendre : public QuadratureRule {
private:
    void generate();
    
public:
    GaussLegendre() = delete;
    
    /**
     * Constructor
     * 
     * \param[in] n number of nodes
     */
    GaussLegendre(LSCMint n) : QuadratureRule(n) {};
    
    ~GaussLegendre() = default;
};

}

#endif
