/* File: DirectSolver.hpp
 *
 * Realization of the direct solver of linear DAEs
 * for a
 * given grid and approximation space. Taken from Barlow 1992
 * 
 * Copyright (C) Michael Hanke 2020
 * Version: 2022-06-06
 */

/* 
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.

*/

#ifndef DIRECTSOLVER_HPP
#define DIRECTSOLVER_HPP

#include "LSCMConfig.hpp"
#include "LinLSQSolver.hpp"
#include "GridFkt.hpp"
#include <Eigen/Dense>
#include <Eigen/SPQRSupport>
#include <Eigen/SparseLU>
#include <limits>

namespace LSCM {

/**
 * Implementation of the classic version of the direct solver
 * 
 * This class provides the direct solver for the discrete system.
 * 
 */
class DirectSolver : public LinLSQSolver {
private:
    // OBS: Using pointers to patch a bug in
    // ~Eigen::SPQR<Eigen::SparseMatrix<double>>() etc
    Eigen::SPQR<LSCMSparseMatrix>* qrX = nullptr;
    Eigen::PermutationMatrix<Eigen::Dynamic,Eigen::Dynamic,LSCMindex> P;
    LSCMSparseMatrix Q;
    LSCMSparseMatrix U1,U2;
    LSCMSparseMatrix X1;
    LSCMint nun;
    LSCMint Xcol;
    LSCMint Arow, Crow;
    
    void resetLocalVars() {
        delete qrX;
        qrX = nullptr;
    }
    
    virtual void factorizeExec();
    
    virtual GridFkt solveExec(const Eigen::VectorXd& f);

public:
    /**
     * Default constructor
     */
    DirectSolver() {}
    
    /**
     * Constructor for the direct solver class
     * 
     * \param[in] genmat pointer to matrix generation object
     */
    DirectSolver(std::shared_ptr<LinLSQMatrices> genmat) :
        LinLSQSolver(genmat) {}
    
    ~DirectSolver() {
        resetLocalVars();
    }
};

}

#endif
