/* File: Chebyshev2.hpp
 *
 * Class implementing the integration on Chebyshev nodes of the second kind
 * 
 * C Michael Hanke 2023
 * Version: 2023-02-13
 */

/* 
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.

*/

#ifndef CHEBYSHEV2_HPP
#define CHEBYSHEV2_HPP

#include "QuadratureRule.hpp"
#include "LSCMConfig.hpp"

namespace LSCM {

/**
 * Implementation of Radau-Legendre quadrature
 * 
 * This class implements the interface of QuadratureRule for the 
 * quadrature at Chebyshev nodes of the first kind
 */
class Chebyshev2 : public QuadratureRule {
private:
    void generate();
    
public:
    Chebyshev2() = delete;
    
    /**
     * Constructor
     * 
     * \param[in] n number of nodes
     */
    Chebyshev2(LSCMint n) : QuadratureRule(n) {}
    
    ~Chebyshev2() = default;
};

}

#endif
