/* File: Chebyshev1.hpp
 *
 * Class implementing the integration on Chebyshev nodes of the first kind
 * 
 * C Michael Hanke 2023
 * Version: 2023-02-13
 */

/* 
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.

*/

#ifndef CHEBYSHEV1_HPP
#define CHEBYSHEV1_HPP

#include "QuadratureRule.hpp"
#include "LSCMConfig.hpp"

namespace LSCM {

/**
 * Implementation of Radau-Legendre quadrature
 * 
 * This class implements the interface of QuadratureRule for the 
 * quadrature at Chebyshev nodes of the first kind
 */
class Chebyshev1 : public QuadratureRule {
private:
    void generate();
    
public:
    Chebyshev1() = delete;
    
    /**
     * Constructor
     * 
     * \param[in] n number of nodes
     */
    Chebyshev1(LSCMint n) : QuadratureRule(n) {}
    
    ~Chebyshev1() = default;
};

}

#endif
