/* File: Chebyshev.hpp
 *
 * This class implements the interface of class Basis using Chebyshev
 * polynomials
 * for representing polynomials.
 * 
 * 
 * Copyright (C) Michael Hanke 2019
 * Version: 2019-12-16
 */

/* 
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.

*/

#ifndef CHEBYSHEV_HPP
#define CHEBYSHEV_HPP

#include "LSCMConfig.hpp"
#include "Basis.hpp"
#include <Eigen/Dense>
#include <iostream>
#include <vector>


namespace LSCM {

/**
 * Implementation of the Chebyshev basis for the DAE
 * 
 * This class implements the interface of class Basis using Chebyshev polynomials
 * for representing polynomials.
 * 
 */
class Chebyshev : public Basis {
private:
    Eigen::VectorXd chebyshevP(double tau, LSCMint n) const;
    
public:
    /**
     * Constructor for the Chebyshev basis
     * 
     * The polynomial degree N of the differential components is
     * provided. 
     * 
     * @param[in] N degree of the approximating differential polynomial
     */
    Chebyshev(LSCMint N) : Basis(N) {}
    
    Eigen::VectorXd evalPa(double tau) const override {
        return chebyshevP(tau,dim);
    }
    Eigen::VectorXd evalPd(double tau) const override;
    Eigen::VectorXd evaldPd(double tau) const override;
};

}

#endif
