/* Exact solution for the index-3 example LinCaMo
 * Check of p-version
 *
 * C Michael Hanke 2020
 * Version 2020-05-13
 */

#ifndef LINCAMO_exsol
#define LINCAMO_exsol

VectorXd LinCaMo_ex(const double t)
{
    VectorXd res(7);
    double st = sin(t);
    double ct = cos(t);
    res << st,
           ct,
           2.0*(ct*ct),
           ct,
           -st,
           -2.0*sin(2.0*t),
           -st/rho;  // Obs: rho must be static and global!
    return res;
}

VectorXd LinCaMo_dex(const double t)
{
    VectorXd res(7);
    double st = sin(t);
    double ct = cos(t);
    res << ct,
           -st,
           -2.0*sin(2.0*t),
           -st,
           -ct,
           -4.0*cos(2.0*t),
           -ct/rho;
    return res;
}

#endif
