/* File DAE2.hpp
 *
 * This is the definition of DAE2
 *
 * Copyright (C) Michael Hanke 2019
 * Version: 2019-12-17
 */

/* 
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.

*/

#ifndef DAE2_HPP
#define DAE2_HPP

#include "DAE.hpp"

using namespace std;
using namespace Eigen;
using namespace LSCM;

class DAE2 : public DAE {
private:
    double eta;
    double lambda;
public:
    DAE2(double eta, double lambda) : eta(eta), lambda(lambda) { l = 1; }
    
    MatrixXd A(double t) {
        MatrixXd res(3,3);
        res << 1.0,0,0,
               0,1.0,0,
               0,0,0;
        return res;
    }

    MatrixXd B(double t) {
        MatrixXd res(3,3);
        res << lambda,-1.0,-1.0,
               eta*t*(1.0-eta*t)-eta,lambda,-eta*t,
               1.0-eta*t, 1.0, 0;
        return res;
    }

    VectorXd q(double t) {
        VectorXd res(3);
        res << (lambda-1.0)*exp(-t)*sin(t)-exp(-2.0*t)*sin(t),
            exp(-2.0*t)*cos(t)-2.0*exp(-2.0*t)*sin(t)-exp(-t)*sin(t)*(eta+eta*t*(eta*t-1.0))+lambda*exp(-2.0*t)*sin(t)-eta*t*exp(-t)*cos(t),
            exp(-2.0*t)*sin(t)-exp(-t)*sin(t)*(eta*t-1.0);
        return res;
    }
    
    vector<bool> getD() {
        return vector<bool>({true,true,false});
    }
    
    MatrixXd getGa() {
        MatrixXd res(1,3);
        res << 0.0,1.0,0.0;
        return res;
    }
    
    MatrixXd getGb() {
        MatrixXd res(1,3);
        res << 0.0,0.0,0.0;
        return res;
    }
    
    VectorXd getr() {
        return VectorXd::Zero(1);
    }
    
};

#endif
