/* Test driver for the index-3 example DAE1
 * Check of p-version
 *
 * Copyright (C) Michael Hanke 2019
 * Version 2019-12-06
 */

/* 
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.

*/

#include "DAE1.hpp"
#include "RKCbasis.hpp"
#include "Legendre.hpp"
#include "Chebyshev.hpp"
#include "GaussLegendre.hpp"
#include "Radau.hpp"
#include "Lobatto.hpp"
#include "Xn.hpp"
#include "LinLSQMatrices.hpp"
#include "LinLSQSolver.hpp"
#include "DirectSolver.hpp"
#include <Eigen/Dense>
#include <memory>
#include <iostream>
#include <cmath>

using namespace Eigen;
using namespace std;
using namespace LSCM;

#include "DAE1_exsol.cpp"

LSCMint main() {
    bool prLSCMint = true;
    LSCMint n = 5;
    LSCMint N = 5;
    LSCMint M = N+1;
    Yn::LSQnorm norm = Yn::LSQ_INT;
    //Yn::IntType inttype = Yn::GAUSS;
    
    //auto basis = make_shared<RKCbasis>(N);
    auto basis = make_shared<Legendre>(N);
    //auto basis = make_shared<Chebyshev>(N);
    auto grid = make_shared<Grid>(0.0,1.0,n);
    // Gauss-Legendre collocation points
    auto collocG = make_shared<Yn>(make_shared<GaussLegendre>(M),norm);
    // Radau IIA collocation points
    auto collocR = make_shared<Yn>(make_shared<Radau>(M,Radau::QR_RIGHT),norm);
    // Lobatto collocation points
    auto collocL = make_shared<Yn>(make_shared<Lobatto>(M),norm);
    
    // Need a dae first: DAE1
    cout << "  *** Solving DAE1 ***" << endl << endl;
    auto dae1 = make_shared<DAE1>(-2.0);
    vector<bool> D1 = dae1->getD();
    auto space1 = make_shared<Xn>(D1,grid,basis);
    
    auto linlsqG1 = make_shared<LinLSQMatrices>(dae1,space1,collocG);
    DirectSolver slv(linlsqG1);
    LinLSQSolver& slvp = slv;
    
    GridFkt sol1 = slvp.solve();
    
    GridFkt exsol1(space1,DAE1ex);
    GridFkt error1 = sol1-exsol1;
    cout << "DAE solved!" << endl << "These are the errors:" << endl;
    cout << "This is for Gauss-Legendre nodes:" << endl;
    cout << "L2 (comp): " << sol1.cl2dist(DAE1ex).transpose() << endl;
    cout << "Inf (comp): " << sol1.cinfdist(DAE1ex).transpose() << endl;
    cout << "L2: " << sol1.l2dist(DAE1ex) << endl;
    cout << "H1: " << sol1.h1dist(DAE1ex,DAE1dex) << endl;
    
    auto linlsqR1 = make_shared<LinLSQMatrices>(dae1,space1,collocR);
    DirectSolver slvL(linlsqR1);
    LinLSQSolver& slvLp = slvL;
    
    GridFkt solL1 = slvLp.solve();
    GridFkt diffL1 = sol1-solL1;
    
    cout << endl << "Now using Radau IIA nodes" << endl;
    cout << "Errors:" << endl;
    cout << "L2 (comp): " << solL1.cl2dist(DAE1ex).transpose() << endl;
    cout << "Inf (comp): " << solL1.cinfdist(DAE1ex).transpose() << endl;
    cout << "L2: " << solL1.l2dist(DAE1ex) << endl;
    cout << "H1: " << solL1.h1dist(DAE1ex,DAE1dex) << endl;
    cout << "Diff to RK solutions" << endl;
    cout << "L2 (comp): " << diffL1.cl2norm().transpose() << endl;
    cout << "Inf (comp): " << diffL1.cinfnorm().transpose() << endl;
    cout << "L2: " << diffL1.l2norm() << endl;
    cout << "H1: " << diffL1.h1norm() << endl;

    auto linlsqL1 = make_shared<LinLSQMatrices>(dae1,space1,collocL);
    DirectSolver slvC(linlsqL1);
    LinLSQSolver& slvCp = slvC;
    
    GridFkt solC1 = slvCp.solve();
    GridFkt diffC1 = sol1-solC1;

    cout << endl << "Now using Lobatto nodes" << endl;
    cout << "Errors:" << endl;
    cout << "L2 (comp): " << solC1.cl2dist(DAE1ex).transpose() << endl;
    cout << "Inf (comp): " << solC1.cinfdist(DAE1ex).transpose() << endl;
    cout << "L2: " << solC1.l2dist(DAE1ex) << endl;
    cout << "H1: " << solC1.h1dist(DAE1ex,DAE1dex) << endl;
    cout << "Diff to RK solutions" << endl;
    cout << "L2 (comp): " << diffC1.cl2norm().transpose() << endl;
    cout << "Inf (comp): " << diffC1.cinfnorm().transpose() << endl;
    cout << "L2: " << diffC1.l2norm() << endl;
    cout << "H1: " << diffC1.h1norm() << endl;

}
