/* Exact solution for the index-3 example DAE1
 * Check of p-version
 *
 * Copyright (C) Michael Hanke 2020
 * Version 2020-04-20
 */

/* 
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.

*/

#ifndef DAE1_exsol
#define DAE1_exsol

VectorXd DAE1ex(const double t)
{
    VectorXd res(3);
    res << exp(-t)*sin(t),
           exp(-2*t)*sin(t),
           exp(-t)*cos(t);
    return res;
}

VectorXd DAE1dex(const double t)
{
    VectorXd res(3);
    res << exp(-t)*(cos(t)-sin(t)),
           exp(-2*t)*(cos(t)-2*sin(t)),
           -exp(-t)*(sin(t)+cos(t));
    return res;
}

#endif
