/* File DAE1.hpp
 *
 * This is the definition of DAE1
 *
 * Copyright (C) Michael Hanke 2019
 * Version: 2019-11-08
 */

/* 
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.

*/

#ifndef DAE1_HPP
#define DAE1_HPP

#include "DAE.hpp"

using namespace std;
using namespace Eigen;
using namespace LSCM;

class DAE1 : public DAE {
private:
    double eta;
public:
    DAE1(double eta) : eta(eta) { l = 0; }
    
    MatrixXd A(double t) {
        MatrixXd res(3,3);
        res << 0,1,0,
               0,t*eta,1,
               0,0,0;
        return res;
    }

    MatrixXd B(double t) {
        MatrixXd res(3,3);
        res << 1,0,0,
               0,eta+1,0,
               0,t*eta,1;
        return res;
    }

    VectorXd q(double t) {
        VectorXd res(3);
        res << exp(-2*t)*(-2*sin(t)+cos(t))+exp(-t)*sin(t),
               exp(-2*t)*(-2*t*eta*sin(t)+t*eta*cos(t)+(eta+1)*sin(t))-exp(-t)*(cos(t)+sin(t)),
               exp(-2*t)*t*eta*sin(t)+exp(-t)*cos(t);
        return res;
    }
    
    vector<bool> getD() {
        return vector<bool>({false,true,true});
    }
    
    MatrixXd getGa() {
        return MatrixXd(0,3);
    }
    
    MatrixXd getGb() {
        return MatrixXd(0,3);
    }
    
    VectorXd getr() {
        return VectorXd(0);
    }
    
};

#endif
