% resinv: Algorithm 2 in E. Ringh and E. Jarlebring,  Nonlinearization
% of two-parameter eigenvalue problems, 2019.
% Please cite this paper if you find this useful
%

function [x,l,y,mu,hist]=resinv(A,B,l0,x0,tol,target)
   AA=@(l,mu) A{1}+A{2}*l+A{3}*mu;
   BB=@(l,mu) B{1}+B{2}*l+B{3}*mu;

   c=ones(size(B{1},1),1);
   w=x0;


   m_prealloc=100;
   hist.resnorm=NaN(m_prealloc,1);
   hist.resnormB=NaN(m_prealloc,1);
   hist.time_count=NaN(m_prealloc,1);


   l=l0;
   x=x0;
   alpha=inf;


   [V,D]=eig(-(B{1}+l*B{2}),B{3});
   [YY,II]=sortrows(abs(diag(D)-target));
   g=D(II(1),II(1)); mu=g;
   y=V(:,II(1));

   t0=tic();
   M=A{1}+A{2}*l+A{3}*g;
   [L,U,P]=lu(M);

   resnorm=inf;
   k=1;
   while ( resnorm > tol)

      A1x=A{1}*x;
      A2x=A{2}*x;
      A3x=A{3}*x;
      a1=w'*A1x;
      a2=w'*A2x;
      a3=w'*A3x;
      [VV,DD]=eig(a3*B{1}-a1*B{3},-a3*B{2}+a2*B{3});
      [~,II]=min(abs(diag(DD)-target));
      resnorms=zeros(size(B{1},1),1);
      for j=1:size(DD,1)
          ll=DD(j,j);
          resnorms(j)=norm(A1x+ll*A2x+mu*A3x);
      end
      [~,II]=min(resnorms);
      l=DD(II,II);
      y=VV(:,II);
      mu=-(a1+l*a2)/a3; g=mu;


      z=A1x+l*A2x+mu*A3x;

      resnorm=norm(z);
      resnorm,l,mu

      u=x-U\(L\(P*z));
      x=u/norm(u);

      hist.resnorm(k)=norm(A{1}*x+l*(A{2}*x)+g*(A{3}*x))/norm(x);
      hist.resnormB(k)=norm(BB(l,g)*y)/norm(y);
      hist.time_count(k)=toc(t0);
      k=k+1
   end

end
