% Augnewton: Algorithm 1 in E. Ringh and E. Jarlebring,  Nonlinearization
% of two-parameter eigenvalue problems, 2019.
% Please cite this paper if you find this useful
% 

function [x,l,y,mu,hist]=augnewton(A,B,l0,x0,tol,target)
   AA=@(l,mu) A{1}+A{2}*l+A{3}*mu;
   BB=@(l,mu) B{1}+B{2}*l+B{3}*mu;

   c=ones(size(B{1},1),1);
   d=x0;

   hist.resnorm=[];
   hist.resnormB=[];
   hist.time_count=[];
   l=l0;
   x=x0;
   alpha=inf;
   t0=tic();
   maxit=20;
   for k=0:maxit

      % Compute a good mu by checking residuals
      A1x=A{1}*x;
      A2x=A{2}*x;
      A3x=A{3}*x;
      [VV,DD]=eig(-(B{1}+l*B{2}),B{3});
      resnorms=zeros(size(B{1},1),1);
      for j=1:size(DD,1)
          mu=DD(j,j);
          resnorms(j)=norm(A1x+l*A2x+mu*A3x);
      end
      [~,II]=min(resnorms);
      g=DD(II(1),II(1)); mu=g;
      y=VV(:,II(1));

      hist.resnorm=[hist.resnorm ; norm(AA(l,g)*x)/norm(x)];
      hist.resnormB=[hist.resnormB ; norm(BB(l,g)*y)/norm(y)];
      hist.time_count=[hist.time_count ; toc(t0)];

      hist.resnorm(k+1)
      if (hist.resnorm(k+1)<tol)
 	 break
      end




      J=[BB(l,g) B{3}*y ; c' , 0];
      q=J\[-B{2}*y;0];;
      gprime=q(end);

      Mpx=A{2}*x+gprime*A{3}*x;

      M=A{1}+A{2}*l+A{3}*g;
      u=M\Mpx;
      alpha=1/(d'*u);
      l=l-alpha;
      x=u*alpha;
   end
end
