% Before running this script you need to load the matrices.
% Do this by either
%  a) run gen_random_example
%  b) load('example1_matrices.mat') and set A={A1,A2,A3}, B={B1,B2,B3}.


% Implementations of the methods
addpath('../common')



% Solutions we wish to compute for reference

lstar =  0.165533648430683 - 0.111376341255953i;
mstar =  0.371293076268452 + 0.240414544172929i;



% Starting values 
l0=round(lstar*20)/20;
m0=round(mstar*20)/20;

v1=ones(size(A{1},1),1);
v2=ones(size(B{1},1),1);
x10=ones(size(A{1},1),1);
x20=ones(size(B{1},1),1);
TOL=1e-10;

[x1,x2,l_plestenjak_resinv,m,p_hist]=plestenjak_resinv(A,B, l0,m0,v1,v2,x10,x20,TOL);

figure(1);
clf;
semilogy(p_hist.resnorm,'--');
hold on;
semilogy(p_hist.resnormB,'--');

target=0;
%[x,l,y,mu,hist]=augnewton(A,B,l0,x10,TOL,target)
[x,l_resinv,y,mu,r_hist]=resinv(A,B,l0,x10,TOL,target)

semilogy(r_hist.resnorm);
semilogy(r_hist.resnormB);
xlabel('iteration');
ylabel('residual norm');

figure(2);
clf;
semilogy(p_hist.time_count,p_hist.resnorm);
hold on;
semilogy(p_hist.time_count,p_hist.resnormB);
semilogy(r_hist.time_count,r_hist.resnorm,'--');
semilogy(r_hist.time_count,r_hist.resnormB,'--');

legend('Plestenjak ResIter norm(Ax)',...
       'Plestenjak ResIter norm(Bx)',...
       'Algorithm 2 resinv norm(Ax)',...
       'Algorithm 2 resinv norm(Bx)')


xlabel('CPU time');
ylabel('residual norm');



%% Augnewton (Our version) vs Inverse iteration  (Plestenjak)

% Starting quite accurate starting vectors
%
x10=round(x*50)/50;
x20=round(y*50)/50;
[x1,x2,l_plestenjak_inviter,m,i_hist]=plestenjak_inviter(A,B, l0,m0,v1,v2,x10,x20,100*TOL);
figure(3);
clf;
semilogy(i_hist.resnorm,'--');
hold on
semilogy(i_hist.resnormB,'--');


[x,l_augnewton,y,mu,a_hist]=augnewton(A,B,l0,x10,100*TOL,m0)

semilogy(a_hist.resnorm);
semilogy(a_hist.resnormB);

xlabel('Iteration');
ylabel('residual norm');


figure(4);
clf;
semilogy(i_hist.time_count,i_hist.resnorm);
hold on;
semilogy(i_hist.time_count,i_hist.resnormB);
semilogy(a_hist.time_count,a_hist.resnorm,'--');
semilogy(a_hist.time_count,a_hist.resnormB,'--');
xlabel('CPU time');
ylabel('residual norm');
legend('Plestenjak InvIter norm(Ax)',...
       'Plestenjak InvIter norm(Bx)',...
       'Algorithm 1 augnewton norm(Ax)',...
       'Algorithm 1 augnewton norm(Bx)')

