% An implementation of the generalization of inverse iteration
% proposed by Plestenjak in
% B. Plestenjak: Numerical methods for nonlinear two-parameter eigenvalue
% problems, BIT Numer. Math. 56 (2016) 241-262
function [x1,x2,l,m,hist]=plestenjak_resinv(A,B, l0,m0,v1,v2,x10,x20,TOL)

   % Note A{1} is -A{1} in §3 in plestenjaks paper
   T1=@(l,m) A{1}+A{2}*l+A{3}*m;
   T2=@(l,m) B{1}+B{2}*l+B{3}*m;
   T1x=@(l,m,x) A{1}*x+l*(A{2}*x)+m*(A{3}*x);
   T2x=@(l,m,x) B{1}*x+l*(B{2}*x)+m*(B{3}*x);
   t0=tic();
   m_prealloc=100;
   hist.resnorm=NaN(m_prealloc,1);
   hist.resnormB=NaN(m_prealloc,1);
   hist.time_count=NaN(m_prealloc,1);


   x1=x10/(v1'*x10);
   x2=x20/(v2'*x20);
   l=l0;
   m=m0;
   errhist1=zeros(100,1);
   errhist2=zeros(100,1);
   k=1;

   while ((norm(T1x(l,m,x1))> TOL) ||  (norm(T2x(l,m,x2))> TOL))
       hist.resnorm(k)=norm(T1x(l,m,x1));
       hist.resnormB(k)=norm(T2(l,m)*x2);
       hist.time_count(k)=toc(t0);
       hist.resnorm(k)
       hist.resnormB(k)
       T1mat=T1(l,m);
       T2mat=T2(l,m);
       a1=T1mat\(A{2}*x1);
       a2=T2mat\(B{2}*x2);
       b1=T1mat\(A{3}*x1);
       b2=T2mat\(B{3}*x2);

       AA=[v1'*a1 v1'*b1 ; v2'*a2 v2'*b2 ];

       dd=-AA\[1;1];
       dl=dd(1);
       dm=dd(2);

       l=l+dl;
       m=m+dm;
       x1=-dl*a1-dm*b1;
       x2=-dl*a2-dm*b2;

       x1=x1/(v1'*x1);
       x2=x2/(v2'*x2);

       %x1=x1/sqrt(x1'*x1);
       %x2=x2/sqrt(x2'*x2);
       %v1=x1;
       %v2=x2;


       k=k+1
   end
   hist.resnorm(k)=norm(T1x(l,m,x1));
   hist.resnormB(k)=norm(T2(l,m)*x2);
   hist.time_count(k)=toc(t0);
   hist.resnorm(k)
   hist.resnormB(k)
