# Plots a couple of solutions
include("load_random.jl");
include("../common/twoparam_NEP.jl");

p=60;
σ=0.0;

eigval_number=1;
dnep1=TwoNEP(A,B,maxder=p,σ=σ,eigval_number=1,mode=:spmf_taylor_DerSPMF)
dnep2=TwoNEP(A,B,maxder=p,σ=σ,eigval_number=2,mode=:spmf_taylor_DerSPMF)
dnep3=TwoNEP(A,B,maxder=p,σ=σ,eigval_number=3,mode=:spmf_taylor_DerSPMF)

v0=ones(n);
(λ1,~,~)=tiar(dnep1,σ=σ,neigs=10,logger=1,tol=1e-7,v=v0,
              maxit=p,errmeasure=ResidualErrmeasure(dnep1),check_error_every=5)

(λ2,~,~)=tiar(dnep2,σ=σ,neigs=10,logger=1,tol=1e-7,v=v0,
              maxit=p,errmeasure=ResidualErrmeasure(dnep2),check_error_every=5)

(λ3,~,~)=tiar(dnep3,σ=σ,neigs=10,logger=1,tol=1e-7,v=v0,
              maxit=p,errmeasure=ResidualErrmeasure(dnep3),check_error_every=5)

# Plot lambda

plot()
plot!(λ1,marker=:star,linecolor=:white)
plot!(λ2,marker=:o,linecolor=:white)
plot!(λ3,marker=:x,linecolor=:white)
plot!(xlabel="Re(lambda)")
plot!(ylabel="Im(lambda)")

mu1=map(x->dnep1.spmf.fi[3](x), λ1)
mu2=map(x->dnep2.spmf.fi[3](x), λ2)
mu3=map(x->dnep3.spmf.fi[3](x), λ3)






plot()
plot!(mu1,marker=:star,linecolor=:white)
plot!(mu2,marker=:o,linecolor=:white)
plot!(mu3,marker=:x,linecolor=:white)
plot!(xlabel="Re(mu)")
plot!(ylabel="Im(mu)")
