# Carries out the simulations
# corresponding to the single vector methods (augnewton, inviter, resinv x 2)
include("load_random.jl");
include("../common/resinv.jl");
include("../common/augnewton.jl");
include("../common/plestenjak_resinv.jl");
include("../common/plestenjak_inviter.jl");

l0=0;
m0=0;

lstar =  0.165533648430683 - 0.111376341255953im;
mstar =  0.371293076268452 + 0.240414544172929im;

#l0=0.1655 - 0.1114i
#l0=0.2 - 0.2i
#m0=0.3713 + 0.2404i
#m0=0.4 + 0.2i
l0=round(lstar*20)/20;
m0=round(mstar*20)/20;

v1=ones(size(A[1],1));
v2=ones(size(B[1],1));
x10=ones(size(A[1],1));
x20=ones(size(B[1],1));
TOL=1e-10;

average_timing_count=5;
println("running plestenjak_resinv $average_timing_count times")
P_hist=zeros(100,average_timing_count)
p_hist=Dict("resnorm" => zeros(0),
            "resnormB" => zeros(0),
            "time_count" => zeros(0));

for j=1:average_timing_count
    (x1,l_plestenjak_resinv,x2,m,p_hist1)=plestenjak_resinv(A,B,l0,m0,
                                                           v1,v2,x10,x20,TOL);
    P_hist[:,j]=p_hist1["time_count"];
    p_hist["resnorm"]=p_hist1["resnorm"]
    p_hist["resnormB"]=p_hist1["resnormB"]
end

p_hist["time_count"]=reshape(sum(P_hist,dims=2)/average_timing_count,100);


plot()
plot!(p_hist["resnorm"],yaxis=:log)
plot!(p_hist["resnormB"],yaxis=:log)
#figure(1);
#clf;
#semilogy(p_hist.resnorm);
#hold on;
#semilogy(p_hist.resnormB);
#
target=0;
#%[x,l,y,mu,hist]=augnewton(A,B,l0,x10,TOL,target)
println("running resinv_TEP $average_timing_count times")
R_hist=zeros(100,average_timing_count)
r_hist=Dict("resnorm" => zeros(0),
            "resnormB" => zeros(0),
            "time_count" => zeros(0));
for j=1:average_timing_count
    (x,l_resinv,y,mu,r_hist1)=resinv_TEP(A,B,l0,x10,TOL,target)
    R_hist[:,j]=r_hist1["time_count"];
    r_hist["resnorm"]=r_hist1["resnorm"]
    r_hist["resnormB"]=r_hist1["resnormB"]
end

r_hist["time_count"]=reshape(sum(R_hist,dims=2)/average_timing_count,100);

#
#semilogy(r_hist.resnorm,'--');
#semilogy(r_hist.resnormB,'--');
#xlabel('iteration');
#ylabel('residual norm');
#
#figure(2);
#clf;
#semilogy(p_hist.time_count,p_hist.resnorm);
#hold on;
#semilogy(p_hist.time_count,p_hist.resnormB);
#semilogy(r_hist.time_count,r_hist.resnorm,'--');
#semilogy(r_hist.time_count,r_hist.resnormB,'--');
#
#legend('Plestenjak ResIter norm(Ax)',...
#       'Plestenjak ResIter norm(Bx)',...
#       'Algorithm 2 resinv norm(Ax)',...
#       'Algorithm 2 resinv norm(Bx)')
#
#
#xlabel('CPU time');
#ylabel('residual norm');
#
#
#
#%% Augnewton (Our version) vs Inverse iteration  (Plestenjak)
#
# Starting quite accurate vectors. This starting vector
#
x10=round.(x*50)/50;
x20=round.(y*50)/50;
println("running plestenjak inviter")
(x1,l_plestenjak_inviterx2,m,x2,i_hist)=plestenjak_inviter(A,B, l0,m0,v1,v2,x10,x20,TOL*10);
#figure(3);
#clf;
#semilogy(i_hist.resnorm);
#hold on
#semilogy(i_hist.resnormB);
#
#
println("running augnewton")
(x,l_augnewton,y,mu,a_hist)=augnewton(A,B,l0,x10,TOL*10,m0)


kmax=maximum([count((!isnan).(r_hist["resnorm"])),
              count((!isnan).(p_hist["resnorm"])),
              count((!isnan).(a_hist["resnorm"])),
              count((!isnan).(i_hist["resnorm"]))]);
using DelimitedFiles
open("../../doc/gfx/example1_resinv.csv","w") do io
  writedlm(io, [1:kmax r_hist["time_count"][1:kmax] r_hist["resnorm"][1:kmax] r_hist["resnormB"][1:kmax]]); # columns of X -> columns in file
end


open("../../doc/gfx/example1_plestenjak_resinv.csv","w") do io
  writedlm(io, [1:kmax p_hist["time_count"][1:kmax] p_hist["resnorm"][1:kmax] p_hist["resnormB"][1:kmax]]); # columns of X -> columns in file
end

open("../../doc/gfx/example1_augnewton.csv","w") do io
  writedlm(io, [1:kmax a_hist["time_count"][1:kmax]  a_hist["resnorm"][1:kmax] a_hist["resnormB"][1:kmax]]); # columns of X -> columns in file
end


open("../../doc/gfx/example1_plestenjak_inviter.csv","w") do io
  writedlm(io, [1:kmax i_hist["time_count"][1:kmax]  i_hist["resnorm"][1:kmax] i_hist["resnormB"][1:kmax]]); # columns of X -> columns in file
end


#
#semilogy(a_hist.resnorm,'--');
#semilogy(a_hist.resnormB,'--');
#
#xlabel('Iteration');
#ylabel('residual norm');
#
#
#figure(4);
#clf;
#semilogy(i_hist.time_count,i_hist.resnorm);
#hold on;
#semilogy(i_hist.time_count,i_hist.resnormB);
#semilogy(a_hist.time_count,a_hist.resnorm,'--');
#semilogy(a_hist.time_count,a_hist.resnormB,'--');
#xlabel('CPU time');
#ylabel('residual norm');
#legend('Plestenjak InvIter norm(Ax)',...
#       'Plestenjak InvIter norm(Bx)',...
#       'Algorithm 1 augnewton norm(Ax)',...
#       'Algorithm 1 augnewton norm(Bx)')
#
#
#k_i=max(find(~isnan(i_hist.time_count)))
#M=[(1:k_i)', i_hist.time_count(1:k_i) , i_hist.resnorm(1:k_i),i_hist.resnormB(1:k_i)	];
#dlmwrite('../../doc/gfx/example1_inviter.csv', M, '\t')
#
#
#k_a=max(find(~isnan(a_hist.time_count)))
#M=[(1:k_a)', a_hist.time_count(1:k_a) , a_hist.resnorm(1:k_a),a_hist.resnormB(1:k_a)	];
#dlmwrite('../../doc/gfx/example1_augnewton.csv', M, '\t')
#
#
#
#
#k_p=max(find(~isnan(p_hist.time_count)))
#M=[(1:k_p)', p_hist.time_count(1:k_p) , p_hist.resnorm(1:k_p),p_hist.resnormB(1:k_p)	];
#dlmwrite('../../doc/gfx/example1_plestenjak_resinv.csv', M, '\t')
#
#
#k_r=max(find(~isnan(r_hist.time_count)))
#M=[(1:k_r)', r_hist.time_count(1:k_r) , r_hist.resnorm(1:k_r),r_hist.resnormB(1:k_r)	];
#dlmwrite('../../doc/gfx/example1_resinv.csv', M, '\t')
#
