# Plots the functions corresponding to the random example
include("load_random.jl");
include("../common/twoparam_NEP.jl");
include("make_continuous.jl")

m0=8;
m00=5
λv=range(-20,stop=20,length=50);
Z=zeros(ComplexF64,m0,length(λv))
for j=1:m0
    mu=s-> gder(B,s,target=0,eigval_number=j)[1][1];
    fv=mu.(λv)
    Z[j,:]=fv;
end


# Sort the eigenvalues such that we get smooth
# curves
make_continuous!(Z);


## Real part
plot();
for j=1:m00
    @show j
    fv=Z[j,:];
    plot!(λv,real.(fv))
end

@show plot!()

## Imaginary part

plot();
for j=1:m00
    @show j
    fv=Z[j,:];
    plot!(λv,imag.(fv))
end

# Uncomment this if you wand the imaginary part
#plot!(;ylim=[-3,3])
#@show plot!(;ylim=[-3,3],xlabel="λ",ylabel="real(μ)")
@show plot!()
