using NonlinearEigenproblems

import NonlinearEigenproblems.push_info!
import NonlinearEigenproblems.push_iteration_info!
struct MyErrorLogger{T} <: Logger  where {T};
    errs::Matrix{T}
    printlogger::Logger
    λref
end

# Collects error history based on
# eigenvalue approximations closest to λref-values

function MyErrorLogger(nof_iters=100,displaylevel=1,λref=[])
    s=Matrix{Float64}(undef,nof_iters,size(λref,1))
    s[:] .= NaN;
    printlogger=PrintLogger(displaylevel)
    return MyErrorLogger{eltype(s)}(s,printlogger,λref);
end



function push_iteration_info!(logger::MyErrorLogger,level,iter;
                              err=Inf,λ=NaN,v=NaN,
                              continues::Bool=false)
    if (iter<=size(logger.errs,1))
        err_vec=err;
        # Make sure err_vec is a vector
        if (err_vec isa Number)
            err_vec=[err_vec]
        end

        λ_tmp=copy(λ);
        err_vec_tmp=copy(err_vec);
        λref_tmp=copy(logger.λref);
        for j=1:size(logger.λref,1)
            r=argmin(abs.(λ_tmp .- logger.λref[j]));
            logger.errs[iter,j]=err_vec_tmp[r];
            λ_tmp[r]=Inf;
            err_vec_tmp[r]=Inf;
        end
        #logger.errs[iter,1:size(err,1)]=err_vec;

    end

    push_iteration_info!(logger.printlogger,level,iter;
                              err=err,λ=λ,v=v,
                              continues=continues)

end
function push_info!(logger::MyErrorLogger,level::Int,
                    v::String;continues::Bool=false)
    push_info!(logger.printlogger,level,v,continues=continues)
end
