# Augnewton: Algorithm 1 in E. Ringh and E. Jarlebring,  Nonlinearization
# of two-parameter eigenvalue problems, 2019.
# Please cite this paper if you find this useful
#
function augnewton(A,B,l0,x0,tol,target)
    AA=(l,mu) -> A[1]+A[2]*l+A[3]*mu;
    BB=(l,mu) -> B[1]+B[2]*l+B[3]*mu;

    c=ones(size(B[1],1),1);
    d=x0;


    # For history collection and time count
    m_prealloc=100;
    hist=Dict("resnorm" => NaN*zeros(m_prealloc),
              "resnormB" => NaN*zeros(m_prealloc),
              "time_count" => NaN*zeros(m_prealloc))

    l=l0;
    x=x0;
    alpha=Inf;
    start_time = time();

    maxit=20;
    for k=1:maxit

        #      [V,D]=eig(-(B[1]+l*B[2]),B[3]);
        #      [YY,II]=sortrows(abs(diag(D)-target));
        #      g=D(II(1),II(1)); mu=g;
        #      y=V(:,II(1));


        A1x=A[1]*x;
        A2x=A[2]*x;
        A3x=A[3]*x;
        L=eigen(-(B[1]+l*B[2]),B[3]);
        VV=L.vectors;
        DD=L.values;
        resnorms=Inf*ones(size(B[1],1));
        for j=1:size(DD,1)
            mu=DD[j];
            if (!isnan(mu)  && abs(mu)<Inf)
                resnorms[j]=norm(A1x+l*A2x+mu*A3x);
            end
        end

        II=argmin(resnorms);
        g=DD[II]; mu=g;
        y=VV[:,II];

        hist["resnorm"][k]=resnorms[II];
        hist["resnormB"][k]=norm(BB(l,g)*y)/norm(y);;
        hist["time_count"][k]=time()-start_time

        @show hist["resnorm"][k]


        if (hist["resnorm"][k]<tol)
 	    break
        end




        J=[BB(l,g) B[3]*y ; c'  0];
        q=J\[-B[2]*y;0];;
        gprime=q[end];

        Mpx=A[2]*x+gprime*A[3]*x;

        M=A[1]+A[2]*l+A[3]*g;
        u=M\Mpx;
        alpha=1/(d'*u);
        l=l-alpha;
        x=u*alpha;
    end
    return (x,l,y,mu,hist);
end
