using NonlinearEigenproblems,LinearAlgebra,Random,MAT,SparseArrays;


function g(x)
    break_point=4.0;
    if (x<break_point)
        return 50 + 30*mod((break_point-x)*2,1)
    else
        omega=20;
        return 50-20*(x-break_point)- 20*sin(omega*pi*(x-break_point))^2
    end
end
k=x->g(x);

a=0; b=5;
# Setup scalar helmholz for an interval
include("helmholtz_fd.jl")
include("helmholtz_cheb.jl")

dtn_point=4.0
(xu,A)=helmholtz_fd(a, dtn_point, n,k);

# Normalize such that residual norm makes more sense
#scale_A=1/maximum(Z->norm(Z), A);
#A=A.*scale_A;


(xv,B)=helmholtz_cheb(dtn_point, b, m,k);

# Test code
#mu=1;
#L=eigen(Matrix(A[1]+mu*A[3]),-Matrix(A[2]));
#II=argmin(abs.(L.values))
#u=L.vectors[:,II];
#@show plot(xu,u/u[end])
#
#((u[end]-u[end-1])/(xu[end]-xu[end-1]))/u[end]
#
#L=eigen(Matrix(B[1]+mu*B[3]),-Matrix(B[2]));
#II=argmin(abs.(L.values))
#v=L.vectors[:,II];
#@show plot!(xv,v/v[end])
#
