# Compute solutions with (tensor) infinite Arnoldi method

include("../common/myerrorlogger.jl");
include("../common/resinv.jl");
n=1000000;
#n=1000;
m=30;
include("setup_helmholtz.jl")
z=diag(A[1]+A[2]+A[3]);

A[1]=spdiagm(0 => 1 ./ z)*A[1]
A[2]=spdiagm(0 => 1 ./ z)*A[2]
A[3]=spdiagm(0 => 1 ./ z)*A[3]
z=diag(B[1]+B[2]+B[3]);
B[1]=spdiagm(0 => 1 ./ z)*B[1]
B[2]=spdiagm(0 => 1 ./ z)*B[2]
B[3]=spdiagm(0 => 1 ./ z)*B[3]

include("../common/twoparam_NEP.jl");
using DelimitedFiles,Plots
p=50;


λref_sort=[51;45;56;60;38;64.7;63.0;27];
n=size(A[1],1);
λv=[];
σ=50.0
#
scaling=10.0;
#
#
dnep2=TwoNEP(A,B,maxder=p,σ=σ,eigval_number=1,mode=:spmf_taylor_DerSPMF)
myerrmeasure = ResidualErrmeasure(dnep2);

logger=MyErrorLogger(100,1,λref_sort);

(λ2,V2)=tiar(Float64,dnep2,σ=σ,γ=scaling,neigs=Inf,
           errmeasure=myerrmeasure,
           logger=logger,tol=1e-12,maxit=p-1,v=ones(n))

muv2=map(s -> get_fv(dnep2)[3](s), λ2)

# Cleanup the convergence plot
err2=logger.errs;
#err0=copy(err);
#err=greedy_resort(err)
plot(err2[:,1],yaxis=:log)
for i=2:size(err2,2)
    plot!(err2[:,i],yaxis=:log);
end
plot!(ylim=[1e-20,10])
#plot!(xlim=[1,30])
plot!(xlabel="Iteration");
plot!(ylabel="Error indicator");
@show plot!()





p=40;
λref_sort=[10,17,5];
scaling=10.0;
σ=12.0
dnep1=TwoNEP(A,B,maxder=p,σ=σ,eigval_number=1,mode=:spmf_taylor_DerSPMF)
myerrmeasure = ResidualErrmeasure(dnep2)
logger1=MyErrorLogger(100,1,λref_sort);
(λ1,V1)=tiar(Float64,dnep1,σ=σ,γ=scaling,neigs=Inf,
           errmeasure=myerrmeasure,
           logger=logger1,tol=1e-12,maxit=p-1,v=ones(n))

muv1=map(s -> get_fv(dnep2)[3](s), λ1)

err1=logger1.errs;


### Save it all
#err2[isinf.(err2)] .= NaN;
#using DelimitedFiles
#open("../../doc/gfx/example2_iar1.csv","w") do io
#  writedlm(io, [1:size(err2,1) err2]); # columns of X -> columns in file
#end
#
#err1[isinf.(err1)] .= NaN;
#open("../../doc/gfx/example2_iar2.csv","w") do io
#  writedlm(io, [1:size(err1,1) err1]); # columns of X -> columns in file
#end
#
#k=size(λ,1)+size(λ1,1);
#open("../../doc/gfx/example2_solution_values.csv","w") do io
#  writedlm(io, [real.([λ1;λ2]) zeros(k)]); # columns of X -> columns in file
#end
#
#singularities=[3.143;19.59 ];
#
#open("../../doc/gfx/example2_singularities.csv","w") do io
#  writedlm(io, [singularities zeros(size(singularities,1))]); # columns of X -> columns in file
#end
#
#
