# Carries out simulations of the single-vector methods

include("../common/resinv.jl");
include("../common/augnewton.jl");
include("../common/plestenjak_resinv.jl");
include("../common/plestenjak_inviter.jl");
n=1000000;
#n=1000;
m=30;
include("setup_helmholtz.jl")
z=diag(A[1]+A[2]+A[3]);

A[1]=spdiagm(0 => 1 ./ z)*A[1]
A[2]=spdiagm(0 => 1 ./ z)*A[2]
A[3]=spdiagm(0 => 1 ./ z)*A[3]
z=diag(B[1]+B[2]+B[3]);
B[1]=spdiagm(0 => 1 ./ z)*B[1]
B[2]=spdiagm(0 => 1 ./ z)*B[2]
B[3]=spdiagm(0 => 1 ./ z)*B[3]



# First compute a reference solution

ll=18;
(x_ref,l_ref,y_ref,mu_ref,hist)=resinv_TEP(A,B,ll,normalize(ones(n)),
                                           1e-20,ll;maxit=20)

normalize!(y_ref);

factor_vec=500;
factor_val=1;
#x0=normalize(round.(x_ref*factor_vec)/factor_vec);
x0=normalize(ones(n));
l0=round(l_ref*factor_val)/factor_val;
y0=normalize(round.(y_ref*factor_vec)/factor_vec);
mu0=round.(mu_ref*factor_val)/factor_val;
tol=1e-15;
@show tol
target=l_ref;
(x,l,y,mu,r_hist)=resinv_TEP(A,B,l0,x0,tol,target;maxit=100,use_resnorms=true)


y0=ones(m);
x10=x0; x20=y0;

(x1,l2,x2,mu2,p_hist)=plestenjak_resinv(A,B, l0, mu0,x0,y0, x10,x20,tol)



(x3,l3,x3,mu3,i_hist)=plestenjak_inviter(A,B, l0, mu0,x0,y0, x10,x20,tol*10)


(x4,l4,x4,mu4,a_hist)=augnewton(A,B,l0,x0,tol*10,mu0)




plot()
plot!(r_hist["resnorm"],yaxis=:log)
plot!(r_hist["resnormB"],yaxis=:log)
plot!(p_hist["resnorm"],yaxis=:log)
plot!(p_hist["resnormB"],yaxis=:log)
plot!(i_hist["resnorm"],yaxis=:log)
plot!(i_hist["resnormB"],yaxis=:log)
plot!(a_hist["resnorm"],yaxis=:log)
plot!(a_hist["resnormB"],yaxis=:log)
plot!(xlim=[0,10])
