# Plots the convergence diagram corresponding to IAR
include("load_random.jl");
include("../common/twoparam_NEP.jl");
include("../common/myerrorlogger.jl");

p=60;
σ=0.0;

eigval_number=1;
dnep1=TwoNEP(A,B,maxder=p,σ=σ,eigval_number=1,mode=:spmf_taylor_DerSPMF)
dnep2=TwoNEP(A,B,maxder=p,σ=σ,eigval_number=2,mode=:spmf_taylor_DerSPMF)
dnep3=TwoNEP(A,B,maxder=p,σ=σ,eigval_number=3,mode=:spmf_taylor_DerSPMF)

branch=2;
if (branch==1)
    dnep=dnep1
elseif (branch==2)
    dnep=dnep2
end
println("Computing reference solutions")
v0=ones(n);
(λref,Vref)=tiar(dnep,σ=σ,neigs=10,logger=1,tol=1e-8,v=v0,
              maxit=p,errmeasure=ResidualErrmeasure(dnep),check_error_every=5)

for k=1:size(λref,1)
    println("Correcting eigval $k");
    (λ,v)=quasinewton(dnep,λ=λref[k],v=Vref[:,k]);
    λref[k]=λ;
    Vref[:,k]=v;
end



logger=MyErrorLogger(100,1,λref);
println("Measure error with reference solution")
myerrmeasure = (λ,v) -> minimum(abs.(λref .- λ)/abs(λ));
(λ,V)=tiar(dnep,σ=σ,neigs=Inf,logger=logger,tol=1e-12,
                     maxit=p-1,
                     errmeasure=myerrmeasure)

err=copy(logger.errs[1:p,:])
using Plots
plot(err[:,1],yaxis=:log)
for i=2:10
    plot!(err[:,i],yaxis=:log);
end
@show plot!()
err[isinf.(err)] .= NaN;
