using Combinatorics;
"""
    make_continuous!(Z,reference=:prev)

Assumes the columns of Z are evaluations of a number of unordered functions, e.g.
from eigenvalues of a matrix. The result uses heuristic to order them.
"""
function make_continuous!(Z,reference=:prev)
    m=size(Z,1)
    pp=collect(permutations(1:m))
    for i=2:size(Z,2)
        if (reference==:prev)
            ref=Z[:,i-1];
        elseif (reference==:first)
            ref=Z[:,1]
        else
            error("unknown reference")
        end
        vv=ones(size(pp,1));
        for k=1:size(pp,1)
            vv[k]=norm(ref-Z[pp[k],i])
        end
        Z[:,i]=Z[pp[argmin(vv)],i];
    end
end
