# resinv_TEP: Algorithm 2 in E. Ringh and E. Jarlebring,  Nonlinearization
# of two-parameter eigenvalue problems, 2019.
# Please cite this paper if you find this useful
#
function resinv_TEP(A,B,l0,x0,tol,target;maxit=100,use_resnorms=false)
    AA=(l,mu) -> A[1]+A[2]*l+A[3]*mu;
    BB=(l,mu) -> B[1]+B[2]*l+B[3]*mu;

    m=size(B[1],1);
    c=ones(m,1);
    w=x0;



    start_time=time();


    # For history collection and time count
    m_prealloc=100;
    hist=Dict("resnorm" => NaN*zeros(m_prealloc),
              "resnormB" => NaN*zeros(m_prealloc),
              "time_count" => NaN*zeros(m_prealloc))

    l=l0;
    x=x0;


    # Start with the mu closest to the target
    alpha=Inf;
    L=eigen((B[1]+l*B[2]),-B[3]);
    V=L.vectors; D=L.values;
    II=sortperm(abs.( D .- target))
    g=D[II[1]]; mu=g;
    @show g
    y=V[:,II[1]];


    M=A[1]+A[2]*l+A[3]*g;
    Mfac=factorize(M);

    resnorm=Inf;
    k=1;
    while ( resnorm > tol && k < maxit)

        # Pick the "best" solution to the GEP.
        A1x=A[1]*x;
        A2x=A[2]*x;
        A3x=A[3]*x;
        a1=w'*A1x;
        a2=w'*A2x;
        a3=w'*A3x;
        L=eigen(a3*B[1]-a1*B[3],-a3*B[2]+a2*B[3]);
        VV=L.vectors;
        DD=L.values;
        if (use_resnorms)
            # We just try all m eigenvalues. Pick the best
            II=argmin(abs.(DD .- target));
            resnorms=zeros(m);
            for j=1:size(DD,1)
                ll=DD[j];
                resnorms[j]=norm(A1x+ll*A2x+mu*A3x);
            end
            # Replace NaN -> Inf for sorting
            resnorms[isnan.(resnorms)] .= Inf
            II=argmin(resnorms);
        else # Select closest to target (lambda-target)
            # No NaNs in sorting
            IJ=findall((!isnan).(DD));
            IJ1=argmin(abs.(DD[IJ] .- target));
            II=IJ[IJ1];
        end

        l=DD[II];

        y=VV[:,II];


        mu=-(a1+l*a2)/a3; g=mu;

        # Compute the residual
        z=A1x+l*A2x+mu*A3x;

        resnorm=norm(z);
        @show resnorm,l,mu

        # Update and normalize
        u=x-Mfac\z;
        x=normalize!(u)

        hist["resnorm"][k]=resnorm;
        hist["resnormB"][k]=norm(BB(l,g)*y)/norm(y);;
        hist["time_count"][k]=time()-start_time

        k=k+1
    end

    return (x,l,y,mu,hist)
end
