include("NEPCore.jl");
import Base.size;
n=10;
nep=get_pep0(n);
# Change the matrices.
nep.A[1]=flipdim(eye(n,n),1);
nep.A[2]=triu(ones(n,n));
nep.A[3]=eye(n,n)*10;
nep.A=[Array{Complex64,2}(nep.A[1]),Array{Complex64,2}(nep.A[2]),
       Array{Complex64,2}(nep.A[3])];


# Create a big matrix
bigfloatnep=get_pep0(n);
bigfloatnep.A=[Array{BigFloat,2}(nep.A[1]),Array{BigFloat,2}(nep.A[2]),
               Array{BigFloat,2}(nep.A[3])]

#for i=1:size(nep.A,1)
#    Ai=nep.A[i];
#    nep.A[i]=view(Ai[1:100,1:100]);
#end
include("broydenmethod.jl")

n=size(nep,1);

#v1=reshape(eye(Complex64,n,1),n);
v1=Vector{Complex64}(ones(n));
T1=inv(bigfloatnep.A[1]);
T1=Array{Complex64,2}(T1)

W1=eye(Complex64,n,1);
CH=ones(Complex64,1,n);
#CH[1]=0; CH[5]=1;
#CH[:]=v1';

v1=v1/(CH*v1)[1];

dnep=NEPBroydenDeflatedEll1(nep,zeros(Complex64,0,0),zeros(Complex64,n,0));

bigfloatdnep=NEPBroydenDeflatedEll1(bigfloatnep,zeros(Complex64,0,0),zeros(Complex64,n,0));

thr=2.0^-2;

println("Jb:");
maxit=1000;
λ1=Complex64(1.0);
(λJ,vJ,u,TX,WX,j,errhistJb)=broyden_naive_J(Complex{BigFloat},bigfloatdnep::NEP;
                                            v1=copy(v1),λ1=λ1,
                                            CH=copy(CH),T1=copy(T1),W1=copy(W1),
                                            threshold=thr,
                                            maxit=maxit,
                                            check_error_every=1,
                                            tol=1e-70,
                                            print_error_every=5
                                            );

println("J:");
(λJ,vJ,u,TX,WX,j,errhistJ)=broyden_naive_J(Complex64,dnep::NEP;
                                           v1=copy(v1),λ1=λ1,
                                           CH=copy(CH),T1=copy(T1),W1=copy(W1),
                                           threshold=thr,
                                           maxit=maxit,
                                           check_error_every=1,
                                           tol=1e-7,
                                            print_error_every=5
                                           );

println("H:");
(λH,vH,u,TX,WX,j,errhistH)=broyden_naive_H(Complex64,dnep::NEP;
                                           v1=copy(v1),λ1=λ1,
                                           CH=copy(CH),T1=copy(T1),W1=copy(W1),
                                           threshold=thr,
                                           maxit=maxit,
                                           check_error_every=1,
                                           tol=1e-7,
                                           print_error_every=5                                                               );


println("T:");
(λT,vT,u,TX,WX,j,errhistT)=broyden_T(Complex64,dnep::NEP;
                                     v1=copy(v1),λ1=λ1,
                                     CH=copy(CH),T1=copy(T1),W1=copy(W1),
                                     threshold=thr,
                                     maxit=maxit,
                                     check_error_every=1,
                                     tol=1e-7,
                                     print_error_every=5                                     
                                     );



using PyPlot;
clf()
semilogy(Array{Float64,1}(errhistJb),"gs",markersize=10,markerfacecolor="None");
hold(true);
semilogy(errhistJ,"k+--");
semilogy(Array{Float64,1}(errhistH),"mx-");
semilogy(Array{Float64,1}(errhistT),"ro--");
legend(["Exact","J","H","T"])

ylim([1e-7,20])
#xlim([450,550])


m=max(size(errhistJb,1),size(errhistH,1),size(errhistT,1),size(errhistJ,1));
Z=NaN*zeros(m,5);
Z[:,1]=1:m;
Z[1:size(errhistJb,1),2]=errhistJb;
Z[1:size(errhistJ,1),3]=errhistJ;
Z[1:size(errhistH,1),4]=errhistH;
Z[1:size(errhistT,1),5]=errhistT;
println("writecsv(\"../gfx/roundoff_conv_data.csv\",Z)")

