
include("NEPCore.jl")

# Load the quadratic eigenvalue problem from Inf Bilanczos paper
nep=QDEP(5);
n0=size(nep,1);
srand(0); # Change to random elements
nep.A=[randn(n0,n0), randn(n0,n0)];


include("broydenmethod.jl")

n=size(nep,1);
λ1=-1; # target
thr=1; # threshold
TT=Complex128 # iteration type

# Minimality index 2
(S2,X2,T1,all_errhist_ell2,all_timehist_ell2,all_iterhist_ell2)=
     deflated_broyden_ell2(TT,nep,nep,σ=λ1,
                           check_error_every=1,
                           print_error_every=10,
                           threshold=thr,
                           tol=1e-10,
                           addconj=false,
                           pmax=10)

# Minimality index 1
(S1,X1,T1,all_errhist_ell1,all_timehist_ell1,all_iterhist_ell1)=
     deflated_broyden(TT,nep,nep,σ=λ1,
                           check_error_every=1,
                           print_error_every=10,
                           threshold=thr,
                           tol=1e-10,
                           addconj=false,
                           pmax=5)






using PyPlot;
figure(1);
clf()
semilogy(all_iterhist_ell1,all_errhist_ell1,"ro-");
hold(true)
semilogy(all_iterhist_ell2,all_errhist_ell2,"k+--");


println("writecsv(\"../gfx/num_comp_ell2_1_data.csv\",[all_iterhist_ell1 all_errhist_ell1])")
println("writecsv(\"../gfx/num_comp_ell2_2_data.csv\",[all_iterhist_ell2 all_errhist_ell2])")
